/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;

public class ToolHarvestLogic {
    private ToolHarvestLogic() {
    }

    public static int getDamage(ToolStack tool, Level world, BlockPos pos, BlockState state) {
        if (state.m_60800_((BlockGetter)world, pos) == 0.0f) {
            return !state.m_60620_((Tag)BlockTags.f_13076_) && ModifierUtil.canPerformAction(tool, ToolActions.SHEARS_DIG) ? 1 : 0;
        }
        return tool.is((Tag<Item>)TinkerTags.Items.HARVEST_PRIMARY) ? 1 : 2;
    }

    public static boolean isEffective(IToolStackView tool, BlockState state) {
        return !tool.isBroken() && tool.getDefinition().getData().getHarvestLogic().isEffective(tool, state);
    }

    public static float getDestroySpeed(ItemStack stack, BlockState state) {
        if (!stack.m_41782_()) {
            return 1.0f;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0.3f;
        }
        return tool.getDefinition().getData().getHarvestLogic().getDestroySpeed(tool, state);
    }

    private static boolean removeBlock(IToolStackView tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken()) {
            ModifierEntry entry;
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = (entry = iterator.next()).getModifier().removeBlock(tool, entry.getLevel(), context)) == null) {
            }
        }
        BlockState state = context.getState();
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        if (removed == null) {
            removed = state.onDestroyedByPlayer((Level)world, pos, (Player)context.getPlayer(), context.canHarvest(), world.m_6425_(pos));
        }
        if (removed.booleanValue()) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return removed;
    }

    protected static boolean breakBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ServerPlayer player = Objects.requireNonNull(context.getPlayer());
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, type)) {
            return false;
        }
        if (player.m_7500_()) {
            ToolHarvestLogic.removeBlock(tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = ToolHarvestLogic.getDamage(tool, (Level)world, pos, state);
        boolean canHarvest = context.canHarvest();
        BlockEntity te = canHarvest ? world.m_7702_(pos) : null;
        boolean removed = ToolHarvestLogic.removeBlock(tool, context);
        Block block = state.m_60734_();
        if (removed && canHarvest) {
            block.m_6240_((Level)world, (Player)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            block.m_49805_(world, pos, exp);
        }
        if (!tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), context);
            }
            ToolDamageUtil.damageAnimated(tool, damage, (LivingEntity)player);
        }
        return true;
    }

    public static void breakExtraBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        if (ToolHarvestLogic.breakBlock(tool, stack, context)) {
            ServerLevel world = context.getWorld();
            BlockPos pos = context.getPos();
            world.m_6798_(2001, pos, Block.m_49956_((BlockState)context.getState()));
            TinkerNetwork.getInstance().sendVanillaPacket((Entity)Objects.requireNonNull(context.getPlayer()), (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        }
    }

    public static boolean handleBlockBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.f_19853_.f_46443_ || !(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel world = serverPlayer.m_183503_();
        ToolStack tool = ToolStack.from(stack);
        BlockState state = world.m_8055_(pos);
        Direction sideHit = BlockSideHitListener.getSideHit(player);
        if (tool.isBroken()) {
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, false, false);
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            ToolHarvestLogic.breakBlock(tool, ItemStack.f_41583_, context);
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
        } else {
            List<BlockPos> extraBlocks;
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, !player.m_7500_() && state.canHarvestBlock((BlockGetter)world, pos, player), ToolHarvestLogic.isEffective(tool, state));
            ListTag originalEnchants = ModifierUtil.applyHarvestEnchantments(tool, stack, context);
            Iterable<BlockPos> iterable = extraBlocks = context.isEffective() ? tool.getDefinition().getData().getAOE().getBlocks(tool, stack, player, state, (Level)world, pos, sideHit, IAreaOfEffectIterator.AOEMatchType.BREAKING) : Collections.emptyList();
            if (ToolHarvestLogic.breakBlock(tool, stack, context)) {
                for (BlockPos extraPos : extraBlocks) {
                    BlockState extraState = world.m_8055_(extraPos);
                    if (extraState.m_60795_()) continue;
                    ToolHarvestLogic.breakExtraBlock(tool, stack, context.forPosition(extraPos.m_7949_(), extraState));
                }
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getModifier().finishBreakingBlocks(tool, entry.getLevel(), context);
                }
            }
            if (originalEnchants != null) {
                ModifierUtil.restoreEnchantments(stack, originalEnchants);
            }
        }
        return true;
    }
}

