/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LazyTag;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.HarvestTiers;

public class FixedTierHarvestLogic
implements IHarvestLogic {
    public static final Loader LOADER = new Loader();
    protected final LazyTag<Block> tag;
    protected final Tier tier;

    public FixedTierHarvestLogic(Tag.Named<Block> tag, Tier tier) {
        this.tag = LazyTag.of(tag);
        this.tier = tier;
    }

    @Override
    public boolean isEffective(IToolStackView tool, BlockState state) {
        return state.m_60620_(this.tag) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(tool), (BlockState)state);
    }

    @Override
    public Tier getTier(IToolStackView tool) {
        return HarvestTiers.min(this.tier, tool.getStats().get(ToolStats.HARVEST_TIER));
    }

    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    public FixedTierHarvestLogic(LazyTag<Block> tag, Tier tier) {
        this.tag = tag;
        this.tier = tier;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<FixedTierHarvestLogic> {
        private Loader() {
        }

        public FixedTierHarvestLogic deserialize(JsonObject json) {
            LazyTag<Block> tag = LazyTag.fromJson(Registry.f_122901_, json, "effective");
            ResourceLocation tierName = JsonHelper.getResourceLocation((JsonObject)json, (String)"tier");
            Tier tier = TierSortingRegistry.byName((ResourceLocation)tierName);
            if (tier == null) {
                throw new JsonSyntaxException("Unknown harvest tier " + tierName);
            }
            return new FixedTierHarvestLogic(tag, tier);
        }

        public FixedTierHarvestLogic fromNetwork(FriendlyByteBuf buffer) {
            LazyTag<Block> tag = LazyTag.fromNetwork(Registry.f_122901_, buffer);
            ResourceLocation name = buffer.m_130281_();
            Tier tier = TierSortingRegistry.byName((ResourceLocation)name);
            if (tier == null) {
                throw new DecoderException("Read unknown tier " + name + " from network");
            }
            return new FixedTierHarvestLogic(tag, tier);
        }

        private static ResourceLocation getTierName(Tier tier) {
            return Objects.requireNonNull(TierSortingRegistry.getName((Tier)tier), "Attempt to serialize unregistered tier");
        }

        public void serialize(FixedTierHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.m_6979_().toString());
            json.addProperty("tier", Loader.getTierName(object.tier).toString());
        }

        public void toNetwork(FixedTierHarvestLogic object, FriendlyByteBuf buffer) {
            object.tag.toNetwork(buffer);
            buffer.m_130085_(Loader.getTierName(object.tier));
        }
    }
}

