/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.StatPredicate;

public class ToolPredicate
extends ItemPredicate {
    public static final ResourceLocation ID = TConstruct.getResource("tool");
    @Nullable
    protected final Item item;
    @Nullable
    protected final Tag<Item> f_45029_;
    protected final List<MaterialId> materials;
    protected final boolean hasUpgrades;
    protected final ModifierMatch upgrades;
    protected final ModifierMatch modifiers;
    protected final List<StatPredicate> stats;

    public boolean m_45049_(ItemStack stack) {
        if (this.f_45029_ != null && !this.f_45029_.m_8110_((Object)stack.m_41720_())) {
            return false;
        }
        if (this.item != null && stack.m_41720_() != this.item) {
            return false;
        }
        if (!stack.m_150922_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        block0: for (MaterialId check : this.materials) {
            for (MaterialVariant mat : tool.getMaterials().getList()) {
                if (!mat.getId().equals(check)) continue;
                continue block0;
            }
            return false;
        }
        if (this.hasUpgrades && tool.getUpgrades().isEmpty()) {
            return false;
        }
        if (this.upgrades != ModifierMatch.ALWAYS && !this.upgrades.test(tool.getUpgrades().getModifiers())) {
            return false;
        }
        if (this.modifiers != ModifierMatch.ALWAYS && !this.modifiers.test(tool.getModifierList())) {
            return false;
        }
        if (!this.stats.isEmpty()) {
            StatsNBT toolStats = tool.getStats();
            for (StatPredicate predicate : this.stats) {
                if (predicate.test(toolStats)) continue;
                return false;
            }
        }
        return true;
    }

    private static <D> JsonArray toArray(List<D> list, Function<D, JsonElement> mapper) {
        JsonArray array = new JsonArray();
        for (D data : list) {
            array.add(mapper.apply(data));
        }
        return array;
    }

    public JsonElement m_45048_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        if (this.item != null) {
            json.addProperty("item", Objects.requireNonNull(this.item.getRegistryName()).toString());
        }
        if (this.f_45029_ != null) {
            json.addProperty("tag", SerializationTags.m_13199_().m_144454_(Registry.f_122904_, this.f_45029_, () -> new IllegalStateException("Unknown item tag")).toString());
        }
        if (!this.materials.isEmpty()) {
            json.add("materials", (JsonElement)ToolPredicate.toArray(this.materials, mat -> new JsonPrimitive(mat.toString())));
        }
        if (this.hasUpgrades) {
            json.addProperty("has_upgrades", Boolean.valueOf(true));
        }
        if (this.upgrades != ModifierMatch.ALWAYS) {
            json.add("upgrades", (JsonElement)this.upgrades.serialize());
        }
        if (this.modifiers != ModifierMatch.ALWAYS) {
            json.add("modifiers", (JsonElement)this.modifiers.serialize());
        }
        if (!this.stats.isEmpty()) {
            json.add("stats", (JsonElement)ToolPredicate.toArray(this.stats, StatPredicate::serialize));
        }
        return json;
    }

    public static ToolPredicate deserialize(JsonObject json) {
        Item item = null;
        if (json.has("item")) {
            item = (Item)RecipeHelper.deserializeItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"item"), (String)"item", Item.class);
        }
        Tag tag = null;
        if (json.has("tag")) {
            ResourceLocation tagName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            tag = SerializationTags.m_13199_().m_144458_(Registry.f_122904_, tagName, name -> new JsonSyntaxException("Unknown item tag '" + name + "'"));
        }
        List materials = Collections.emptyList();
        if (json.has("materials")) {
            materials = JsonHelper.parseList((JsonObject)json, (String)"materials", (element, key) -> new MaterialId(GsonHelper.m_13805_((JsonElement)element, (String)key)));
        }
        boolean hasUpgrades = GsonHelper.m_13855_((JsonObject)json, (String)"has_upgrades", (boolean)false);
        ModifierMatch upgrades = ModifierMatch.ALWAYS;
        if (json.has("upgrades")) {
            upgrades = ModifierMatch.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"upgrades"));
        }
        ModifierMatch modifiers = ModifierMatch.ALWAYS;
        if (json.has("modifiers")) {
            modifiers = ModifierMatch.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"modifiers"));
        }
        List stats = Collections.emptyList();
        if (json.has("stats")) {
            stats = JsonHelper.parseList((JsonObject)json, (String)"stats", StatPredicate::deserialize);
        }
        return new ToolPredicate(item, (Tag<Item>)tag, materials, hasUpgrades, upgrades, modifiers, stats);
    }

    public static Builder builder(Item item) {
        return new Builder(item, null);
    }

    public static Builder builder(Tag<Item> tag) {
        return new Builder(null, tag);
    }

    public static Builder builder() {
        return new Builder(null, null);
    }

    protected ToolPredicate(@Nullable Item item, @Nullable Tag<Item> tag, List<MaterialId> materials, boolean hasUpgrades, ModifierMatch upgrades, ModifierMatch modifiers, List<StatPredicate> stats) {
        this.item = item;
        this.f_45029_ = tag;
        this.materials = materials;
        this.hasUpgrades = hasUpgrades;
        this.upgrades = upgrades;
        this.modifiers = modifiers;
        this.stats = stats;
    }

    public static class Builder {
        @Nullable
        protected final Item item;
        @Nullable
        protected final Tag<Item> tag;
        protected final List<MaterialId> materials = new ArrayList<MaterialId>();
        protected boolean hasUpgrades = false;
        protected ModifierMatch upgrades = ModifierMatch.ALWAYS;
        protected ModifierMatch modifiers = ModifierMatch.ALWAYS;
        protected final List<StatPredicate> stats = new ArrayList<StatPredicate>();

        protected Builder(@Nullable Item item, @Nullable Tag<Item> tag) {
            this.item = item;
            this.tag = tag;
        }

        public Builder withMaterial(MaterialId material) {
            this.materials.add(material);
            return this;
        }

        public Builder withStat(StatPredicate predicate) {
            this.stats.add(predicate);
            return this;
        }

        public ToolPredicate build() {
            return new ToolPredicate(this.item, this.tag, this.materials, this.hasUpgrades, this.upgrades, this.modifiers, this.stats);
        }

        public Builder hasUpgrades(boolean hasUpgrades) {
            this.hasUpgrades = hasUpgrades;
            return this;
        }

        public Builder upgrades(ModifierMatch upgrades) {
            this.upgrades = upgrades;
            return this;
        }

        public Builder modifiers(ModifierMatch modifiers) {
            this.modifiers = modifiers;
            return this;
        }
    }
}

