/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.PartBuilderContainerWrapper;

public interface IPartBuilderRecipe
extends ICommonRecipe<IPartBuilderContainer> {
    public Pattern getPattern();

    public int getCost();

    public boolean partialMatch(IPartBuilderContainer var1);

    default public int getItemsUsed(IPartBuilderContainer inv) {
        return Optional.ofNullable(inv.getMaterial()).map(mat -> mat.getItemsUsed(this.getCost())).orElse(1);
    }

    default public RecipeType<?> m_6671_() {
        return RecipeTypes.PART_BUILDER;
    }

    default public ItemStack m_8042_() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    default public ItemStack getLeftover(PartBuilderContainerWrapper inventoryWrapper) {
        int remainder;
        int value;
        MaterialRecipe recipe = inventoryWrapper.getMaterial();
        if (recipe != null && (value = recipe.getValue()) > 1 && (remainder = value - this.getCost() % value) > 0) {
            ItemStack leftover = recipe.getLeftover();
            leftover.m_41764_(leftover.m_41613_() * remainder);
            return leftover;
        }
        return ItemStack.f_41583_;
    }
}

