/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoldingRecipeBuilder
extends AbstractRecipeBuilder<MoldingRecipeBuilder> {
    private final ItemOutput output;
    private final MoldingRecipe.Serializer<?> serializer;
    private Ingredient material = Ingredient.f_43901_;
    private Ingredient pattern = Ingredient.f_43901_;
    private boolean patternConsumed = false;

    public static MoldingRecipeBuilder moldingTable(ItemLike item) {
        return MoldingRecipeBuilder.molding(ItemOutput.fromItem((ItemLike)item), (MoldingRecipe.Serializer)TinkerSmeltery.moldingTableSerializer.get());
    }

    public static MoldingRecipeBuilder moldingBasin(ItemLike item) {
        return MoldingRecipeBuilder.molding(ItemOutput.fromItem((ItemLike)item), (MoldingRecipe.Serializer)TinkerSmeltery.moldingBasinSerializer.get());
    }

    public MoldingRecipeBuilder setMaterial(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public MoldingRecipeBuilder setMaterial(ItemLike item) {
        return this.setMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public MoldingRecipeBuilder setMaterial(Tag<Item> tag) {
        return this.setMaterial(Ingredient.m_43911_(tag));
    }

    public MoldingRecipeBuilder setPattern(Ingredient ingredient, boolean consumed) {
        this.pattern = ingredient;
        this.patternConsumed = consumed;
        return this;
    }

    public MoldingRecipeBuilder setPattern(ItemLike item, boolean consumed) {
        return this.setPattern(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), consumed);
    }

    public MoldingRecipeBuilder setPattern(Tag<Item> tag, boolean consumed) {
        return this.setPattern(Ingredient.m_43911_(tag), consumed);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(this.output.get().m_41720_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.material == Ingredient.f_43901_) {
            throw new IllegalStateException("Missing material for molding recipe");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "molding");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId));
    }

    private MoldingRecipeBuilder(ItemOutput output, MoldingRecipe.Serializer<?> serializer) {
        this.output = output;
        this.serializer = serializer;
    }

    public static MoldingRecipeBuilder molding(ItemOutput output, MoldingRecipe.Serializer<?> serializer) {
        return new MoldingRecipeBuilder(output, serializer);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MoldingRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            json.add("material", MoldingRecipeBuilder.this.material.m_43942_());
            if (MoldingRecipeBuilder.this.pattern != Ingredient.f_43901_) {
                json.add("pattern", MoldingRecipeBuilder.this.pattern.m_43942_());
                if (MoldingRecipeBuilder.this.patternConsumed) {
                    json.addProperty("pattern_consumed", Boolean.valueOf(true));
                }
            }
            json.add("result", MoldingRecipeBuilder.this.output.serialize());
        }

        public RecipeSerializer<?> m_6637_() {
            return MoldingRecipeBuilder.this.serializer;
        }
    }
}

