/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.recipe.TagPredicate;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class PotionFluidEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final float effectScale;
    private final TagPredicate predicate;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Potion potion;
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getAttacker();
        if (target != null && this.predicate.test(fluid.getTag()) && (potion = PotionUtils.m_43577_((CompoundTag)fluid.getTag())) != Potions.f_43598_) {
            int oldInvulnerableTime = target.f_19802_;
            float totalScale = scale * this.effectScale;
            for (MobEffectInstance instance : potion.m_43488_()) {
                MobEffect effect = instance.m_19544_();
                if (effect.m_8093_()) {
                    target.f_19802_ = 0;
                    effect.m_19461_((Entity)attacker, (Entity)attacker, target, instance.m_19564_(), (double)totalScale);
                    continue;
                }
                int duration = (int)((float)instance.m_19557_() * totalScale);
                if (duration <= 10) continue;
                target.m_7292_(new MobEffectInstance(effect, duration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
            }
            target.f_19802_ = oldInvulnerableTime;
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    public PotionFluidEffect(float effectScale, TagPredicate predicate) {
        this.effectScale = effectScale;
        this.predicate = predicate;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<PotionFluidEffect> {
        private Loader() {
        }

        public PotionFluidEffect deserialize(JsonObject json) {
            float scale = GsonHelper.m_13915_((JsonObject)json, (String)"scale");
            TagPredicate predicate = TagPredicate.ANY;
            if (json.has("predicate")) {
                predicate = TagPredicate.deserialize(json.get("predicate"));
            }
            return new PotionFluidEffect(scale, predicate);
        }

        public PotionFluidEffect fromNetwork(FriendlyByteBuf buffer) {
            float scale = buffer.readFloat();
            TagPredicate predicate = TagPredicate.read(buffer);
            return new PotionFluidEffect(scale, predicate);
        }

        public void serialize(PotionFluidEffect effect, JsonObject json) {
            json.addProperty("scale", (Number)Float.valueOf(effect.effectScale));
            if (effect.predicate != TagPredicate.ANY) {
                json.add("predicate", effect.predicate.serialize());
            }
        }

        public void toNetwork(PotionFluidEffect effect, FriendlyByteBuf buffer) {
            buffer.writeFloat(effect.effectScale);
            effect.predicate.write(buffer);
        }
    }
}

