/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class EffectSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final MobEffect effect;
    private final int time;
    private final int level;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        int time;
        LivingEntity target = context.getLivingTarget();
        if (target != null && (time = (int)((float)(this.time * 20) * scale)) > 0) {
            target.m_7292_(new MobEffectInstance(this.effect, time, this.level - 1));
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    public EffectSpillingEffect(MobEffect effect, int time, int level) {
        this.effect = effect;
        this.time = time;
        this.level = level;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<EffectSpillingEffect> {
        private Loader() {
        }

        public EffectSpillingEffect deserialize(JsonObject json) {
            ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"name");
            if (!ForgeRegistries.MOB_EFFECTS.containsKey(id)) {
                throw new JsonSyntaxException("Unknown effect " + id);
            }
            MobEffect effect = Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id));
            int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
            return new EffectSpillingEffect(effect, time, level);
        }

        public EffectSpillingEffect fromNetwork(FriendlyByteBuf buffer) {
            MobEffect effect = (MobEffect)buffer.readRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS);
            int level = buffer.m_130242_();
            int time = buffer.m_130242_();
            return new EffectSpillingEffect(effect, time, level);
        }

        public void serialize(EffectSpillingEffect effect, JsonObject json) {
            json.addProperty("name", Objects.requireNonNull(effect.effect.getRegistryName()).toString());
            json.addProperty("time", (Number)effect.time);
            json.addProperty("level", (Number)effect.level);
        }

        public void toNetwork(EffectSpillingEffect effect, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS, (IForgeRegistryEntry)effect.effect);
            buffer.m_130130_(effect.time);
            buffer.m_130130_(effect.level);
        }
    }
}

