/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SpillingRecipeBuilder
extends AbstractRecipeBuilder<SpillingRecipeBuilder> {
    private final FluidIngredient fluid;
    private final List<ISpillingEffect> effects = new ArrayList<ISpillingEffect>();

    public static SpillingRecipeBuilder forFluid(FluidStack fluid) {
        return new SpillingRecipeBuilder(FluidIngredient.of((FluidStack)fluid));
    }

    public static SpillingRecipeBuilder forFluid(Fluid fluid, int amount) {
        return new SpillingRecipeBuilder(FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    public static SpillingRecipeBuilder forFluid(Tag<Fluid> fluid, int amount) {
        return new SpillingRecipeBuilder(FluidIngredient.of(fluid, (int)amount));
    }

    public SpillingRecipeBuilder addEffect(ISpillingEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(((FluidStack)this.fluid.getFluids().get(0)).getFluid().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.effects.isEmpty()) {
            throw new IllegalStateException("Must have at least one effect to build");
        }
        consumer.accept((FinishedRecipe)new Finished(id, null));
    }

    private SpillingRecipeBuilder(FluidIngredient fluid) {
        this.fluid = fluid;
    }

    public static SpillingRecipeBuilder forFluid(FluidIngredient fluid) {
        return new SpillingRecipeBuilder(fluid);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)SpillingRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            json.add("fluid", SpillingRecipeBuilder.this.fluid.serialize());
            JsonArray effectArray = new JsonArray();
            for (ISpillingEffect effect : SpillingRecipeBuilder.this.effects) {
                effectArray.add((JsonElement)ISpillingEffect.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)effect));
            }
            json.add("effects", (JsonElement)effectArray);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.spillingSerializer.get();
        }
    }
}

