/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.IEmptyContainer;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SpillingRecipe
implements ICustomOutputRecipe<IEmptyContainer> {
    private final ResourceLocation id;
    private final FluidIngredient ingredient;
    private final List<ISpillingEffect> effects;

    public boolean matches(Fluid fluid) {
        return this.ingredient.test(fluid);
    }

    public FluidStack applyEffects(FluidStack fluid, int level, ToolAttackContext context) {
        int needed = this.ingredient.getAmount(fluid.getFluid());
        int maxFluid = level * needed;
        float scale = level;
        if (fluid.getAmount() < maxFluid) {
            scale = (float)fluid.getAmount() / (float)maxFluid;
        }
        for (ISpillingEffect effect : this.effects) {
            effect.applyEffects(fluid, scale, context);
        }
        fluid.shrink(maxFluid);
        return fluid;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.spillingSerializer.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.SPILLING;
    }

    @Deprecated
    public boolean matches(IEmptyContainer inv, Level worldIn) {
        return false;
    }

    public SpillingRecipe(ResourceLocation id, FluidIngredient ingredient, List<ISpillingEffect> effects) {
        this.id = id;
        this.ingredient = ingredient;
        this.effects = effects;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<SpillingRecipe> {
        public SpillingRecipe fromJson(ResourceLocation id, JsonObject json) {
            FluidIngredient ingredient = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            List effects = JsonHelper.parseList((JsonObject)json, (String)"effects", arg_0 -> ISpillingEffect.LOADER.deserialize(arg_0));
            return new SpillingRecipe(id, ingredient, effects);
        }

        @Nullable
        protected SpillingRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            FluidIngredient ingredient = FluidIngredient.read((FriendlyByteBuf)buffer);
            ImmutableList.Builder effects = ImmutableList.builder();
            int max = buffer.m_130242_();
            for (int i = 0; i < max; ++i) {
                effects.add((Object)((ISpillingEffect)ISpillingEffect.LOADER.fromNetwork(buffer)));
            }
            return new SpillingRecipe(id, ingredient, (List<ISpillingEffect>)effects.build());
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, SpillingRecipe recipe) {
            recipe.ingredient.write(buffer);
            buffer.m_130130_(recipe.effects.size());
            for (ISpillingEffect effect : recipe.effects) {
                ISpillingEffect.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)effect, buffer);
            }
        }
    }
}

