/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.IEmptyContainer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SeveringRecipe
implements ICustomOutputRecipe<IEmptyContainer> {
    private final ResourceLocation id;
    protected final EntityIngredient ingredient;
    protected final ItemOutput output;
    private List<List<EntityType>> displayInputs;

    public boolean matches(EntityType<?> type) {
        return this.ingredient.test(type);
    }

    public ItemStack getOutput() {
        return this.output.get();
    }

    public ItemStack getOutput(Entity entity) {
        return this.getOutput().m_41777_();
    }

    public Collection<EntityType<?>> getInputs() {
        return this.ingredient.getTypes();
    }

    public List<List<EntityType>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = ImmutableList.of((Object)ImmutableList.copyOf(this.getInputs()));
        }
        return this.displayInputs;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.severingSerializer.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.SEVERING;
    }

    @Deprecated
    public boolean matches(IEmptyContainer inv, Level worldIn) {
        return false;
    }

    public SeveringRecipe(ResourceLocation id, EntityIngredient ingredient, ItemOutput output) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<SeveringRecipe> {
        public SeveringRecipe fromJson(ResourceLocation id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            ItemOutput output = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            return new SeveringRecipe(id, ingredient, output);
        }

        @Nullable
        protected SeveringRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            EntityIngredient ingredient = EntityIngredient.read((FriendlyByteBuf)buffer);
            ItemOutput output = ItemOutput.read((FriendlyByteBuf)buffer);
            return new SeveringRecipe(id, ingredient, output);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, SeveringRecipe recipe) {
            recipe.ingredient.write(buffer);
            recipe.output.write(buffer);
        }
    }
}

