/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.salvage;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.RandomItem;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSalvage
extends AbstractModifierSalvage {
    private final List<RandomItem> result;

    public ModifierSalvage(ResourceLocation id, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, List<RandomItem> result, @Nullable SlotType.SlotCount slots) {
        super(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        this.result = result;
        ModifierRecipeLookup.addSalvage(this);
    }

    @Override
    public void acceptItems(IToolStackView tool, Consumer<ItemStack> stackConsumer, Random random) {
        for (RandomItem randomItem : this.result) {
            ItemStack stack = randomItem.get(random);
            if (stack.m_41619_()) continue;
            stackConsumer.accept(stack);
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
    }

    public static class Serializer
    extends AbstractModifierSalvage.AbstractSerializer<ModifierSalvage> {
        @Override
        protected ModifierSalvage fromJson(ResourceLocation id, JsonObject json, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            Object result = ImmutableList.of();
            if (json.has("salvage")) {
                result = JsonHelper.parseList((JsonObject)json, (String)"salvage", RandomItem::fromJson);
            }
            return new ModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, (List<RandomItem>)result, slots);
        }

        @Override
        protected ModifierSalvage fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            ImmutableList.Builder result = ImmutableList.builder();
            int count = buffer.m_130242_();
            for (int i = 0; i < count; ++i) {
                result.add((Object)RandomItem.read(buffer));
            }
            return new ModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, (List<RandomItem>)result.build(), slots);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, ModifierSalvage recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.m_130130_(recipe.result.size());
            for (RandomItem randomItem : recipe.result) {
                randomItem.write(buffer);
            }
        }
    }
}

