/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.salvage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;

public abstract class AbstractModifierSalvage
implements ICustomOutputRecipe<Container> {
    protected final ResourceLocation id;
    protected final Ingredient toolIngredient;
    protected final int maxToolSize;
    protected final Modifier modifier;
    protected final int minLevel;
    protected final int maxLevel;
    @Nullable
    protected final SlotType.SlotCount slots;

    public boolean matches(ItemStack stack, IToolStackView tool, int originalLevel) {
        return originalLevel >= this.minLevel && originalLevel <= this.maxLevel && this.toolIngredient.test(stack);
    }

    public void updateTool(IToolStackView tool) {
        if (this.slots != null) {
            tool.getPersistentData().addSlots(this.slots.getType(), this.slots.getCount());
        }
    }

    public abstract void acceptItems(IToolStackView var1, Consumer<ItemStack> var2, Random var3);

    public RecipeType<?> m_6671_() {
        return RecipeTypes.DATA;
    }

    @Deprecated
    public boolean m_5818_(Container inv, Level level) {
        return false;
    }

    public AbstractModifierSalvage(ResourceLocation id, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this.id = id;
        this.toolIngredient = toolIngredient;
        this.maxToolSize = maxToolSize;
        this.modifier = modifier;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.slots = slots;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getMaxToolSize() {
        return this.maxToolSize;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public static abstract class AbstractSerializer<T extends AbstractModifierSalvage>
    extends LoggingRecipeSerializer<T> {
        protected abstract T fromJson(ResourceLocation var1, JsonObject var2, Ingredient var3, int var4, Modifier var5, int var6, int var7, @Nullable SlotType.SlotCount var8);

        protected abstract T fromNetwork(ResourceLocation var1, FriendlyByteBuf var2, Ingredient var3, int var4, Modifier var5, int var6, int var7, @Nullable SlotType.SlotCount var8);

        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient toolIngredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"tools"));
            int maxToolSize = GsonHelper.m_13824_((JsonObject)json, (String)"max_tool_size", (int)16);
            Modifier modifier = ModifierEntry.deserializeModifier(json, "modifier");
            int minLevel = JsonUtils.getIntMin(json, "min_level", 1);
            int maxLevel = GsonHelper.m_13824_((JsonObject)json, (String)"max_level", (int)Integer.MAX_VALUE);
            if (maxLevel < minLevel) {
                throw new JsonSyntaxException("Max level must be greater than or equal to min level");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"slots"));
            }
            return this.fromJson(id, json, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        }

        @Nullable
        protected T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient toolIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int maxToolSize = buffer.m_130242_();
            Modifier modifier = (Modifier)buffer.readRegistryIdUnsafe(TinkerRegistries.MODIFIERS);
            int minLevel = buffer.m_130242_();
            int maxLevel = buffer.m_130242_();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return this.fromNetwork(id, buffer, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
            ((AbstractModifierSalvage)recipe).toolIngredient.m_43923_(buffer);
            buffer.m_130130_(((AbstractModifierSalvage)recipe).getMaxToolSize());
            buffer.writeRegistryIdUnsafe(TinkerRegistries.MODIFIERS, (IForgeRegistryEntry)((AbstractModifierSalvage)recipe).modifier);
            buffer.m_130130_(((AbstractModifierSalvage)recipe).minLevel);
            buffer.m_130130_(((AbstractModifierSalvage)recipe).maxLevel);
            SlotType.SlotCount.write(((AbstractModifierSalvage)recipe).slots, buffer);
        }
    }
}

