/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RandomItem;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<ModifierRecipeBuilder> {
    protected final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();
    private final List<RandomItem> salvage = new ArrayList<RandomItem>();

    protected ModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static ModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new ModifierRecipeBuilder(modifier);
    }

    public static ModifierRecipeBuilder modifier(Modifier modifier) {
        return ModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public ModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public ModifierRecipeBuilder addInput(Ingredient ingredient) {
        return this.addInput(SizedIngredient.of((Ingredient)ingredient));
    }

    public ModifierRecipeBuilder addInput(ItemLike item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (ItemLike[])new ItemLike[]{item}));
    }

    public ModifierRecipeBuilder addInput(ItemLike item) {
        return this.addInput(item, 1);
    }

    public ModifierRecipeBuilder addInput(Tag<Item> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public ModifierRecipeBuilder addInput(Tag<Item> tag) {
        return this.addInput(tag, 1);
    }

    public ModifierRecipeBuilder addSalvage(RandomItem item) {
        this.salvage.add(item);
        return this;
    }

    public ModifierRecipeBuilder addSalvage(ItemLike item, float chance) {
        return this.addSalvage(RandomItem.chance(ItemOutput.fromItem((ItemLike)item), chance));
    }

    public ModifierRecipeBuilder addSalvage(ItemLike item, int minAmount, int maxAmount) {
        return this.addSalvage(RandomItem.range(ItemOutput.fromStack((ItemStack)new ItemStack(item, maxAmount)), minAmount));
    }

    public ModifierRecipeBuilder addSalvage(ItemLike item, int maxAmount) {
        return this.addSalvage(item, 0, maxAmount);
    }

    public ModifierRecipeBuilder addSalvage(Tag<Item> tag, int minAmount, int maxAmount) {
        return this.addSalvage(RandomItem.range(ItemOutput.fromTag(tag, (int)maxAmount), minAmount));
    }

    public ModifierRecipeBuilder addInputSalvage(ItemLike item, int minAmount, int maxAmount) {
        this.addInput(item, maxAmount);
        this.addSalvage(item, minAmount, maxAmount);
        return this;
    }

    public ModifierRecipeBuilder addInputSalvage(ItemLike item, int amount) {
        return this.addInputSalvage(item, 0, amount);
    }

    public ModifierRecipeBuilder addInputSalvage(ItemLike item, float salvageChance) {
        this.addInput(item);
        this.addSalvage(item, salvageChance);
        return this;
    }

    public ModifierRecipeBuilder addInputSalvage(Tag<Item> tag, int minAmount, int maxAmount) {
        this.addInput(SizedIngredient.fromTag(tag, (int)maxAmount));
        this.addSalvage(tag, minAmount, maxAmount);
        return this;
    }

    public ModifierRecipeBuilder addInputSalvage(Tag<Item> tag, int amount) {
        return this.addInputSalvage(tag, 0, amount);
    }

    public ModifierRecipeBuilder addInputSalvage(Tag<Item> tag, float salvageChance) {
        this.addInput(SizedIngredient.fromTag(tag, (int)1));
        this.addSalvage(RandomItem.chance(ItemOutput.fromTag(tag, (int)1), salvageChance));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new FinishedAdding(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((FinishedRecipe)new FinishedAdding(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_unarmed"), null, true));
        }
    }

    @Override
    public ModifierRecipeBuilder saveSalvage(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new FinishedSalvage(id, advancementId));
        return this;
    }

    protected class FinishedAdding
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedAdding(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(ID, advancementID, withUnarmed);
        }

        @Override
        public void m_7917_(JsonObject json) {
            JsonArray array = new JsonArray();
            for (SizedIngredient ingredient : ModifierRecipeBuilder.this.inputs) {
                array.add((JsonElement)ingredient.serialize());
            }
            json.add("inputs", (JsonElement)array);
            super.m_7917_(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.modifierSerializer.get();
        }
    }

    private class FinishedSalvage
    extends AbstractModifierRecipeBuilder.SalvageFinishedRecipe {
        public FinishedSalvage(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super(ID, advancementID);
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (!ModifierRecipeBuilder.this.salvage.isEmpty()) {
                JsonArray array = new JsonArray();
                for (RandomItem randomItem : ModifierRecipeBuilder.this.salvage) {
                    array.add(randomItem.serialize());
                }
                json.add("salvage", (JsonElement)array);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
        }
    }
}

