/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipe
extends AbstractModifierRecipe {
    protected final List<SizedIngredient> inputs;

    public ModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        super(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        this.inputs = inputs;
    }

    protected static BitSet makeBitset(ITinkerStationContainer inv) {
        int inputs = inv.getInputCount();
        BitSet used = new BitSet(inputs);
        for (int i = 0; i < inputs; ++i) {
            if (!inv.getInput(i).m_41619_()) continue;
            used.set(i);
        }
        return used;
    }

    protected static int findMatch(SizedIngredient ingredient, ITinkerStationContainer inv, BitSet used) {
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack;
            if (used.get(i) || !ingredient.test(stack = inv.getInput(i))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : this.inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) continue;
            return false;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            if (used.get(i) || inv.getInput(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ValidatedResult commonError = this.validatePrerequisites(tool);
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        SlotType.SlotCount slots = this.getSlots();
        if (slots != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        tool.addModifier(this.result.getModifier(), this.result.getLevel());
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : this.inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) {
                inv.shrinkInput(index, ingredient.getAmountNeeded());
                continue;
            }
            TConstruct.LOG.warn("Missing ingredient in modifier recipe input consume");
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSerializer.get();
    }

    @Override
    protected void addIngredients(Consumer<List<ItemStack>> builder) {
        for (SizedIngredient ingredient : this.inputs) {
            builder.accept(ingredient.getMatchingStacks());
        }
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<ModifierRecipe> {
        @Override
        public ModifierRecipe fromJson(ResourceLocation id, JsonObject json, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            return new ModifierRecipe(id, ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        public ModifierRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            return new ModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, ModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
        }
    }
}

