/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<IncrementalModifierRecipeBuilder> {
    private Ingredient input = Ingredient.f_43901_;
    private ItemOutput salvage = null;
    private int amountPerItem;
    private int neededPerLevel;
    private ItemStack leftover = ItemStack.f_41583_;
    private boolean fullSalvage = false;

    protected IncrementalModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new IncrementalModifierRecipeBuilder(modifier);
    }

    public static IncrementalModifierRecipeBuilder modifier(Modifier modifier) {
        return IncrementalModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public IncrementalModifierRecipeBuilder setInput(Ingredient input, int amountPerItem, int neededPerLevel) {
        if (amountPerItem < 1) {
            throw new IllegalArgumentException("Amount per item must be at least 1");
        }
        if (neededPerLevel <= amountPerItem) {
            throw new IllegalArgumentException("Needed per level must be greater than amount per item");
        }
        this.input = input;
        this.amountPerItem = amountPerItem;
        this.neededPerLevel = neededPerLevel;
        return this;
    }

    public IncrementalModifierRecipeBuilder setInput(ItemLike item, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setInput(Tag<Item> tag, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_43911_(tag), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setSalvage(ItemOutput salvage, boolean fullOutput) {
        this.salvage = salvage;
        this.fullSalvage = fullOutput;
        return this;
    }

    public IncrementalModifierRecipeBuilder setSalvage(ItemLike item, int amountPerItem, boolean fullOutput) {
        return this.setSalvage(ItemOutput.fromStack((ItemStack)new ItemStack(item, amountPerItem)), fullOutput);
    }

    public IncrementalModifierRecipeBuilder setSalvage(ItemLike item, boolean fullOutput) {
        return this.setSalvage(item, 1, fullOutput);
    }

    public IncrementalModifierRecipeBuilder setInputSalvage(ItemLike item, int amountPerItem, int neededPerLevel, boolean fullOutput) {
        this.setInput(item, amountPerItem, neededPerLevel);
        this.setSalvage(item, amountPerItem, fullOutput);
        return this;
    }

    public IncrementalModifierRecipeBuilder setInputSalvage(Tag<Item> tag, int amountPerItem, int neededPerLevel, boolean fullOutput) {
        this.setInput(tag, amountPerItem, neededPerLevel);
        this.setSalvage(ItemOutput.fromTag(tag, (int)amountPerItem), fullOutput);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.input == Ingredient.f_43901_) {
            throw new IllegalStateException("Must set input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new FinishedAdding(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((FinishedRecipe)new FinishedAdding(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_unarmed"), null, true));
        }
    }

    @Override
    public IncrementalModifierRecipeBuilder saveSalvage(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new FinishedSalvage(id, advancementId));
        return this;
    }

    public static JsonElement serializeResult(ItemStack result) {
        String itemName = Objects.requireNonNull(result.m_41720_().getRegistryName()).toString();
        if (result.m_41782_()) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", itemName);
            int count = result.m_41613_();
            if (count > 1) {
                jsonResult.addProperty("count", (Number)count);
            }
            jsonResult.addProperty("nbt", Objects.requireNonNull(result.m_41783_()).toString());
            return jsonResult;
        }
        return new JsonPrimitive(itemName);
    }

    public IncrementalModifierRecipeBuilder setLeftover(ItemStack leftover) {
        this.leftover = leftover;
        return this;
    }

    private class FinishedAdding
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedAdding(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(IncrementalModifierRecipeBuilder.this, ID, advancementID, withUnarmed);
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.add("input", IncrementalModifierRecipeBuilder.this.input.m_43942_());
            json.addProperty("amount_per_item", (Number)IncrementalModifierRecipeBuilder.this.amountPerItem);
            json.addProperty("needed_per_level", (Number)IncrementalModifierRecipeBuilder.this.neededPerLevel);
            if (IncrementalModifierRecipeBuilder.this.leftover != ItemStack.f_41583_) {
                json.add("leftover", IncrementalModifierRecipeBuilder.serializeResult(IncrementalModifierRecipeBuilder.this.leftover));
            }
            super.m_7917_(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.incrementalModifierSerializer.get();
        }
    }

    private class FinishedSalvage
    extends AbstractModifierRecipeBuilder.SalvageFinishedRecipe {
        public FinishedSalvage(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super(IncrementalModifierRecipeBuilder.this, ID, advancementID);
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (IncrementalModifierRecipeBuilder.this.salvage != null) {
                JsonObject salvageObject;
                JsonElement salvageElement = IncrementalModifierRecipeBuilder.this.salvage.serialize();
                if (salvageElement.isJsonObject()) {
                    salvageObject = salvageElement.getAsJsonObject();
                } else {
                    salvageObject = new JsonObject();
                    salvageObject.add("item", salvageElement);
                    salvageObject.addProperty("full", Boolean.valueOf(IncrementalModifierRecipeBuilder.this.fullSalvage));
                }
                json.add("salvage", (JsonElement)salvageObject);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return IncrementalModifierRecipeBuilder.this.salvage == null ? (RecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get() : (RecipeSerializer)TinkerModifiers.incrementalModifierSalvageSerializer.get();
        }
    }
}

