/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public interface IDisplayModifierRecipe
extends IModifierRecipe {
    public static final Function<Item, ItemStack> MAP_TOOL_FOR_RENDERING = IModifiableDisplay::getDisplayStack;

    public List<List<ItemStack>> getDisplayItems();

    public List<ItemStack> getToolWithModifier();

    public ModifierEntry getDisplayResult();

    @Override
    default public Modifier getModifier() {
        return this.getDisplayResult().getModifier();
    }

    default public int getMaxLevel() {
        return 0;
    }

    @Nullable
    default public SlotType.SlotCount getSlots() {
        return null;
    }

    @Override
    @Nullable
    default public SlotType getSlotType() {
        SlotType.SlotCount count = this.getSlots();
        if (count == null) {
            return null;
        }
        return count.getType();
    }

    default public boolean hasRequirements() {
        return false;
    }

    default public String getRequirementsError() {
        return "";
    }

    default public boolean isIncremental() {
        return false;
    }

    public static Stream<Item> getAllModifiable() {
        return TinkerTags.Items.MODIFIABLE.m_6497_().stream();
    }

    public static ItemStack withModifiers(ItemStack stack, @Nullable ModifierMatch match, @Nullable ModifierEntry newModifier) {
        return IDisplayModifierRecipe.withModifiers(stack, match, newModifier, data -> {});
    }

    public static ItemStack withModifiers(ItemStack stack, @Nullable ModifierMatch match, @Nullable ModifierEntry newModifier, Consumer<ModDataNBT> persistentDataConsumer) {
        ItemStack output = stack.m_41777_();
        CompoundTag nbt = output.m_41784_();
        ModifierNBT.Builder builder = ModifierNBT.builder();
        if (match != null) {
            match.apply(builder);
        }
        if (newModifier != null) {
            builder.add(newModifier);
        }
        ModifierNBT modifiers = builder.build();
        ListTag list = modifiers.serializeToNBT();
        nbt.m_128365_("tic_upgrades", (Tag)list);
        nbt.m_128365_("tic_modifiers", (Tag)list);
        CompoundTag persistentNBT = new CompoundTag();
        ModDataNBT persistentData = ModDataNBT.readFromNBT(persistentNBT);
        CompoundTag volatileNBT = new CompoundTag();
        ModDataNBT volatileData = ModDataNBT.readFromNBT(volatileNBT);
        persistentDataConsumer.accept(persistentData);
        ToolRebuildContext context = new ToolRebuildContext(stack.m_41720_(), ToolDefinition.EMPTY, MaterialNBT.EMPTY, modifiers, modifiers, StatsNBT.EMPTY, persistentData, volatileData);
        for (ModifierEntry entry : modifiers.getModifiers()) {
            entry.getModifier().addVolatileData(context, entry.getLevel(), volatileData);
        }
        nbt.m_128365_("tic_volatile_data", (Tag)volatileNBT);
        nbt.m_128365_("tic_persistent_data", (Tag)persistentNBT);
        return output;
    }
}

