/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingRecipe
implements IMeltingRecipe {
    private final ResourceLocation id;
    protected final String group;
    protected final Ingredient input;
    protected final FluidStack output;
    protected final int temperature;
    protected final int time;
    protected final List<FluidStack> byproducts;
    private List<List<FluidStack>> outputWithByproducts;

    public boolean matches(IMeltingContainer inv, Level world) {
        return this.input.test(inv.getStack());
    }

    @Override
    public int getTemperature(IMeltingContainer inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingContainer inv) {
        return this.time;
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.meltingSerializer.get();
    }

    @Nullable
    public IMeltingContainer.OreRateType getOreType() {
        return null;
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        for (FluidStack fluidStack : this.byproducts) {
            handler.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public List<List<FluidStack>> getDisplayOutput() {
        return Collections.singletonList(Collections.singletonList(this.output));
    }

    public List<List<FluidStack>> getOutputWithByproducts() {
        if (this.outputWithByproducts == null) {
            this.outputWithByproducts = Stream.concat(Stream.of(this.output), this.byproducts.stream()).map(Collections::singletonList).collect(Collectors.toList());
        }
        return this.outputWithByproducts;
    }

    public MeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
        this.byproducts = byproducts;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    protected FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer<T extends MeltingRecipe>
    extends AbstractSerializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T createFromJson(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, JsonObject json) {
            return this.factory.create(id, group, input, output, temperature, time, byproducts);
        }

        @Override
        protected T createFromNetwork(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, FriendlyByteBuf buffer) {
            return this.factory.create(id, group, input, output, temperature, time, byproducts);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    protected static abstract class AbstractSerializer<T extends MeltingRecipe>
    extends LoggingRecipeSerializer<T> {
        protected AbstractSerializer() {
        }

        protected abstract T createFromJson(ResourceLocation var1, String var2, Ingredient var3, FluidStack var4, int var5, int var6, List<FluidStack> var7, JsonObject var8);

        protected abstract T createFromNetwork(ResourceLocation var1, String var2, Ingredient var3, FluidStack var4, int var5, int var6, List<FluidStack> var7, FriendlyByteBuf var8);

        public T fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int temperature = GsonHelper.m_13927_((JsonObject)json, (String)"temperature");
            int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            if (temperature < 0) {
                throw new JsonSyntaxException("Melting temperature must be greater than zero");
            }
            if (time <= 0) {
                throw new JsonSyntaxException("Melting time must be greater than zero");
            }
            List byproducts = Collections.emptyList();
            if (json.has("byproducts")) {
                byproducts = JsonHelper.parseList((JsonObject)json, (String)"byproducts", RecipeHelper::deserializeFluidStack);
            }
            return this.createFromJson(id, group, input, output, temperature, time, byproducts, json);
        }

        @Nullable
        protected T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            int temperature = buffer.readInt();
            int time = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            int byproductCount = buffer.m_130242_();
            for (int i = 0; i < byproductCount; ++i) {
                builder.add((Object)FluidStack.readFromPacket((FriendlyByteBuf)buffer));
            }
            return this.createFromNetwork(id, group, input, output, temperature, time, (List<FluidStack>)builder.build(), buffer);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((MeltingRecipe)recipe).group);
            ((MeltingRecipe)recipe).input.m_43923_(buffer);
            ((MeltingRecipe)recipe).output.writeToPacket(buffer);
            buffer.writeInt(((MeltingRecipe)recipe).temperature);
            buffer.m_130130_(((MeltingRecipe)recipe).time);
            buffer.m_130130_(((MeltingRecipe)recipe).byproducts.size());
            for (FluidStack fluidStack : ((MeltingRecipe)recipe).byproducts) {
                fluidStack.writeToPacket(buffer);
            }
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends MeltingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, FluidStack var4, int var5, int var6, List<FluidStack> var7);
    }
}

