/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.ISingleStackContainer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialRecipe
implements ICustomOutputRecipe<ISingleStackContainer> {
    public static final float INGOTS_PER_REPAIR = 3.0f;
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final int value;
    protected final int needed;
    protected final MaterialVariant material;
    protected final ItemOutput leftover;
    @Nullable
    private Float repairPerItem;
    private List<ItemStack> displayItems = null;

    public MaterialRecipe(ResourceLocation id, String group, Ingredient ingredient, int value, int needed, MaterialVariantId materialId, ItemOutput leftover) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.value = value;
        this.needed = needed;
        this.material = MaterialVariant.of(materialId);
        this.leftover = leftover;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.MATERIAL;
    }

    public ItemStack m_8042_() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.materialRecipeSerializer.get();
    }

    public boolean matches(ISingleStackContainer inv, Level worldIn) {
        return !this.material.isUnknown() && this.ingredient.test(inv.getStack());
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    public List<ItemStack> getDisplayItems() {
        if (this.displayItems == null) {
            this.displayItems = this.needed > 1 ? Arrays.stream(this.ingredient.m_43908_()).map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)this.needed)).collect(Collectors.toList()) : Arrays.asList(this.ingredient.m_43908_());
        }
        return this.displayItems;
    }

    public float getMaterialValue(ISingleStackContainer inv) {
        return (float)(inv.getStack().m_41613_() * this.value) / (float)this.needed;
    }

    public int getItemsUsed(int itemCost) {
        int needed = itemCost * this.needed;
        int cost = needed / this.value;
        if (needed % this.value != 0) {
            ++cost;
        }
        return cost;
    }

    public int getRemainder(int itemCost) {
        return itemCost * this.needed % this.value;
    }

    public float getRepairPerItem(ToolDefinitionData data, @Nullable MaterialStatsId statsId) {
        if (this.repairPerItem == null) {
            this.repairPerItem = Float.valueOf((float)(this.getValue() * MaterialRecipe.getRepairDurability(data, this.material.getId(), statsId)) / 3.0f / (float)this.getNeeded());
        }
        return this.repairPerItem.floatValue();
    }

    public static int getRepairDurability(ToolDefinitionData toolData, MaterialId materialId, @Nullable MaterialStatsId statsId) {
        Optional<IMaterialStats> optional = statsId != null ? MaterialRegistry.getInstance().getMaterialStats(materialId, statsId).filter(stats -> stats instanceof IRepairableMaterialStats) : MaterialRegistry.getInstance().getAllStats(materialId).stream().filter(stats -> stats instanceof IRepairableMaterialStats).findFirst();
        return optional.map(stats -> ((IRepairableMaterialStats)stats).getDurability()).orElseGet(() -> toolData.getBaseStat(ToolStats.DURABILITY).intValue());
    }

    public ItemStack getLeftover() {
        return this.leftover.get().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getValue() {
        return this.value;
    }

    public int getNeeded() {
        return this.needed;
    }

    public MaterialVariant getMaterial() {
        return this.material;
    }
}

