/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.IFluidContainer;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;

public class MeltingFuel
implements ICustomOutputRecipe<IFluidContainer> {
    private final ResourceLocation id;
    private final String group;
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;

    public MeltingFuel(ResourceLocation id, String group, FluidIngredient input, int duration, int temperature) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
        for (FluidStack fluid : input.getFluids()) {
            MeltingFuelLookup.addFuel(fluid.getFluid(), this);
        }
    }

    public boolean matches(IFluidContainer inv, Level worldIn) {
        return this.matches(inv.getFluid());
    }

    public boolean matches(Fluid fluid) {
        return this.input.test(fluid);
    }

    public int getAmount(IFluidContainer inv) {
        return this.getAmount(inv.getFluid());
    }

    public int getAmount(Fluid fluid) {
        return this.input.getAmount(fluid);
    }

    public List<FluidStack> getInputs() {
        return this.input.getFluids();
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.FUEL;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.fuelSerializer.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MeltingFuel> {
        public MeltingFuel fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            FluidIngredient input = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
            int temperature = GsonHelper.m_13927_((JsonObject)json, (String)"temperature");
            return new MeltingFuel(id, group, input, duration, temperature);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, MeltingFuel recipe) {
            buffer.m_130070_(recipe.group);
            recipe.input.write(buffer);
            buffer.writeInt(recipe.duration);
            buffer.writeInt(recipe.temperature);
        }

        @Nullable
        protected MeltingFuel fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            FluidIngredient input = FluidIngredient.read((FriendlyByteBuf)buffer);
            int duration = buffer.readInt();
            int temperature = buffer.readInt();
            return new MeltingFuel(id, group, input, duration, temperature);
        }
    }
}

