/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeManager;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;

public class EntityMeltingRecipeCache {
    private static final Map<EntityType<?>, EntityMeltingRecipe> CACHE = new HashMap();

    @Nullable
    public static EntityMeltingRecipe findRecipe(RecipeManager manager, EntityType<?> type) {
        if (CACHE.containsKey(type)) {
            return CACHE.get(type);
        }
        for (EntityMeltingRecipe recipe : RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.ENTITY_MELTING, EntityMeltingRecipe.class)) {
            if (!recipe.matches(type)) continue;
            CACHE.put(type, recipe);
            return recipe;
        }
        CACHE.put(type, null);
        return null;
    }

    private EntityMeltingRecipeCache() {
    }

    static {
        RecipeCacheInvalidator.addReloadListener(client -> CACHE.clear());
    }
}

