/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.IEmptyContainer;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class EntityMeltingRecipe
implements ICustomOutputRecipe<IEmptyContainer> {
    private final ResourceLocation id;
    private final EntityIngredient ingredient;
    private final FluidStack output;
    private final int damage;
    private List<List<EntityType>> displayInputs;

    public boolean matches(EntityType<?> type) {
        return this.ingredient.test(type);
    }

    public FluidStack getOutput(LivingEntity entity) {
        return this.output.copy();
    }

    public List<List<EntityType>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = ImmutableList.of((Object)ImmutableList.copyOf(this.getInputs()));
        }
        return this.displayInputs;
    }

    public Collection<EntityType<?>> getInputs() {
        return this.ingredient.getTypes();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.entityMeltingSerializer.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.ENTITY_MELTING;
    }

    @Deprecated
    public boolean matches(IEmptyContainer inv, Level worldIn) {
        return false;
    }

    public EntityMeltingRecipe(ResourceLocation id, EntityIngredient ingredient, FluidStack output, int damage) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getDamage() {
        return this.damage;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<EntityMeltingRecipe> {
        public EntityMeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int damage = GsonHelper.m_13824_((JsonObject)json, (String)"damage", (int)2);
            return new EntityMeltingRecipe(id, ingredient, output, damage);
        }

        @Nullable
        protected EntityMeltingRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            EntityIngredient ingredient = EntityIngredient.read((FriendlyByteBuf)buffer);
            FluidStack output = buffer.readFluidStack();
            int damage = buffer.m_130242_();
            return new EntityMeltingRecipe(id, ingredient, output, damage);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, EntityMeltingRecipe recipe) {
            recipe.ingredient.write(buffer);
            buffer.writeFluidStack(recipe.output);
            buffer.m_130130_(recipe.damage);
        }
    }
}

