/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialFluidRecipeBuilder
extends AbstractRecipeBuilder<MaterialFluidRecipeBuilder> {
    private final MaterialVariantId outputId;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int temperature = -1;
    @Nullable
    private MaterialVariantId inputId;

    public MaterialFluidRecipeBuilder setFluidAndTemp(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of((FluidStack)fluidStack);
        if (this.temperature == -1) {
            this.temperature = fluidStack.getFluid().getAttributes().getTemperature(fluidStack) - 300;
        }
        return this;
    }

    public MaterialFluidRecipeBuilder setFluid(Tag<Fluid> tagIn, int amount) {
        this.setFluid(FluidIngredient.of(tagIn, (int)amount));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.outputId.getId());
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Material fluid recipes require a fluid input");
        }
        if (this.temperature < 0) {
            throw new IllegalStateException("Temperature is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "materials");
        consumer.accept((FinishedRecipe)new Result(id, advancementId));
    }

    private MaterialFluidRecipeBuilder(MaterialVariantId outputId) {
        this.outputId = outputId;
    }

    public static MaterialFluidRecipeBuilder material(MaterialVariantId outputId) {
        return new MaterialFluidRecipeBuilder(outputId);
    }

    public MaterialFluidRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public MaterialFluidRecipeBuilder setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public MaterialFluidRecipeBuilder setInputId(@Nullable MaterialVariantId inputId) {
        this.inputId = inputId;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MaterialFluidRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            if (MaterialFluidRecipeBuilder.this.inputId != null) {
                json.addProperty("input", MaterialFluidRecipeBuilder.this.inputId.toString());
            }
            json.add("fluid", MaterialFluidRecipeBuilder.this.fluid.serialize());
            json.addProperty("temperature", (Number)MaterialFluidRecipeBuilder.this.temperature);
            json.addProperty("output", MaterialFluidRecipeBuilder.this.outputId.toString());
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerSmeltery.materialFluidRecipe.get();
        }
    }
}

