/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialCastingLookup {
    private static final Object2IntMap<IMaterialItem> ITEM_COST_LOOKUP = new Object2IntOpenHashMap(50);
    private static final Map<Fluid, MaterialFluidRecipe> CASTING_FLUIDS = new HashMap<Fluid, MaterialFluidRecipe>();
    private static final List<MaterialFluidRecipe> COMPOSITE_FLUIDS = new ArrayList<MaterialFluidRecipe>();
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        ITEM_COST_LOOKUP.clear();
        CASTING_FLUIDS.clear();
        COMPOSITE_FLUIDS.clear();
    });

    public static void registerItemCost(IMaterialItem item, int cost) {
        LISTENER.checkClear();
        if (ITEM_COST_LOOKUP.containsKey((Object)item)) {
            int original = ITEM_COST_LOOKUP.getInt((Object)item);
            if (cost != original) {
                TConstruct.LOG.error("Inconsistent cost for item {}", (Object)item.m_5456_().getRegistryName());
                ITEM_COST_LOOKUP.put((Object)item, Math.min(cost, original));
            }
        } else {
            ITEM_COST_LOOKUP.put((Object)item, cost);
        }
    }

    public static void registerFluid(MaterialFluidRecipe recipe) {
        LISTENER.checkClear();
        if (recipe.getInput() == null) {
            for (FluidStack fluidStack : recipe.getFluids()) {
                CASTING_FLUIDS.put(fluidStack.getFluid(), recipe);
            }
        } else {
            COMPOSITE_FLUIDS.add(recipe);
        }
    }

    public static int getItemCost(IMaterialItem item) {
        return ITEM_COST_LOOKUP.getOrDefault((Object)item, 0);
    }

    public static int getItemCost(Item item) {
        return ITEM_COST_LOOKUP.getOrDefault((Object)item, 0);
    }

    public static Collection<Object2IntMap.Entry<IMaterialItem>> getAllItemCosts() {
        return ITEM_COST_LOOKUP.object2IntEntrySet();
    }

    public static Optional<MaterialFluidRecipe> getCastingFluid(Fluid fluid) {
        return Optional.ofNullable(CASTING_FLUIDS.get(fluid));
    }

    public static Optional<MaterialFluidRecipe> getCompositeFluid(ICastingContainer inventory) {
        for (MaterialFluidRecipe recipe : COMPOSITE_FLUIDS) {
            if (!recipe.matches(inventory)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static List<MaterialFluidRecipe> getCastingFluids(MaterialVariantId material) {
        return CASTING_FLUIDS.values().stream().filter(recipe -> material.matchesVariant(recipe.getOutput())).collect(Collectors.toList());
    }

    public static List<MaterialFluidRecipe> getCompositeFluids(MaterialVariantId material) {
        return COMPOSITE_FLUIDS.stream().filter(recipe -> material.matchesVariant(recipe.getOutput())).collect(Collectors.toList());
    }

    public static Collection<MaterialFluidRecipe> getAllCastingFluids() {
        return CASTING_FLUIDS.values();
    }

    public static Collection<MaterialFluidRecipe> getAllCompositeFluids() {
        return COMPOSITE_FLUIDS;
    }

    private MaterialCastingLookup() {
    }
}

