/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class CompositeCastingRecipeBuilder
extends AbstractRecipeBuilder<CompositeCastingRecipeBuilder> {
    private final IMaterialItem result;
    private final int itemCost;
    private final CompositeCastingRecipe.Serializer<?> serializer;

    public static CompositeCastingRecipeBuilder basin(IMaterialItem result, int itemCost) {
        return CompositeCastingRecipeBuilder.composite(result, itemCost, (CompositeCastingRecipe.Serializer)TinkerSmeltery.basinCompositeSerializer.get());
    }

    public static CompositeCastingRecipeBuilder table(IMaterialItem result, int itemCost) {
        return CompositeCastingRecipeBuilder.composite(result, itemCost, (CompositeCastingRecipe.Serializer)TinkerSmeltery.tableCompositeSerializer.get());
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(this.result.m_5456_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId));
    }

    private CompositeCastingRecipeBuilder(IMaterialItem result, int itemCost, CompositeCastingRecipe.Serializer<?> serializer) {
        this.result = result;
        this.itemCost = itemCost;
        this.serializer = serializer;
    }

    public static CompositeCastingRecipeBuilder composite(IMaterialItem result, int itemCost, CompositeCastingRecipe.Serializer<?> serializer) {
        return new CompositeCastingRecipeBuilder(result, itemCost, serializer);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)CompositeCastingRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            if (!CompositeCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", CompositeCastingRecipeBuilder.this.group);
            }
            json.addProperty("result", Objects.requireNonNull(CompositeCastingRecipeBuilder.this.result.m_5456_().getRegistryName()).toString());
            json.addProperty("item_cost", (Number)CompositeCastingRecipeBuilder.this.itemCost);
        }

        public RecipeSerializer<?> m_6637_() {
            return CompositeCastingRecipeBuilder.this.serializer;
        }
    }
}

