/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.IAlloyTank;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipe
implements ICustomOutputRecipe<IAlloyTank> {
    private final ResourceLocation id;
    private final List<FluidIngredient> inputs;
    private final FluidStack output;
    private final int temperature;
    private List<List<FluidStack>> displayInputs;

    public List<List<FluidStack>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = this.inputs.stream().map(FluidIngredient::getFluids).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    private static BitSet makeBitset(IAlloyTank inv) {
        int tanks = inv.getTanks();
        BitSet used = new BitSet(tanks);
        for (int i = 0; i < tanks; ++i) {
            if (!inv.getFluidInTank(i).isEmpty()) continue;
            used.set(i);
        }
        return used;
    }

    private static int findMatch(FluidIngredient ingredient, IAlloyTank inv, BitSet used, boolean checkSize) {
        for (int i = 0; i < inv.getTanks(); ++i) {
            if (used.get(i)) continue;
            FluidStack fluid = inv.getFluidInTank(i);
            if (!(checkSize ? ingredient.test(fluid) : ingredient.test(fluid.getFluid()))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    public boolean matches(IAlloyTank inv, Level worldIn) {
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, false);
            if (index != -1) continue;
            return false;
        }
        return true;
    }

    public boolean canPerform(IAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return false;
        }
        BitSet used = AlloyRecipe.makeBitset(inv);
        int drainAmount = 0;
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1) {
                FluidStack fluid = inv.getFluidInTank(index);
                drainAmount += ingredient.getAmount(fluid.getFluid());
                continue;
            }
            return false;
        }
        return inv.canFit(this.output, drainAmount);
    }

    public void performRecipe(IMutableAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return;
        }
        FluidStack[] drainFluids = new FluidStack[inv.getTanks()];
        int drainAmount = 0;
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1 && drainFluids[index] == null) {
                FluidStack fluid = inv.getFluidInTank(index);
                int amount = ingredient.getAmount(fluid.getFluid());
                drainAmount += amount;
                drainFluids[index] = new FluidStack(fluid, amount);
                continue;
            }
            return;
        }
        if (inv.canFit(this.output, drainAmount)) {
            for (int i = 0; i < drainFluids.length; ++i) {
                FluidStack drained;
                FluidStack toDrain = drainFluids[i];
                if (toDrain == null || (drained = inv.drain(i, toDrain)).getAmount() == toDrain.getAmount()) continue;
                TConstruct.LOG.error("Wrong amount of fluid {} drained for recipe {}", (Object)drained.getFluid(), (Object)this.id);
            }
            int filled = inv.fill(this.output.copy());
            if (filled != this.output.getAmount()) {
                TConstruct.LOG.error("Filled only {} for recipe {}", (Object)filled, (Object)this.id);
            }
        }
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.ALLOYING;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.alloyingSerializer.get();
    }

    public AlloyRecipe(ResourceLocation id, List<FluidIngredient> inputs, FluidStack output, int temperature) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.temperature = temperature;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<AlloyRecipe> {
        public AlloyRecipe fromJson(ResourceLocation id, JsonObject json) {
            FluidStack result = RecipeHelper.deserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            List inputs = JsonHelper.parseList((JsonObject)json, (String)"inputs", FluidIngredient::deserialize);
            if (inputs.size() < 2) {
                throw new JsonSyntaxException("Too few inputs to alloy recipe " + id);
            }
            for (FluidIngredient input : inputs) {
                if (!input.test(result)) continue;
                throw new JsonSyntaxException("Result fluid contained in input in alloy recipe " + id);
            }
            int temperature = GsonHelper.m_13927_((JsonObject)json, (String)"temperature");
            return new AlloyRecipe(id, inputs, result, temperature);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, AlloyRecipe recipe) {
            buffer.writeFluidStack(recipe.output);
            buffer.m_130130_(recipe.inputs.size());
            for (FluidIngredient input : recipe.inputs) {
                input.write(buffer);
            }
            buffer.m_130130_(recipe.temperature);
        }

        @Nullable
        protected AlloyRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            FluidStack output = buffer.readFluidStack();
            int inputCount = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inputCount; ++i) {
                builder.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
            }
            int temperature = buffer.m_130242_();
            return new AlloyRecipe(id, (List<FluidIngredient>)builder.build(), output, temperature);
        }
    }
}

