/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class IncrementalModifier
extends Modifier {
    @Override
    public Component getDisplayName(IToolStackView tool, int level) {
        int amount;
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this);
        Component name = this.getDisplayName(level);
        if (neededPerLevel > 0 && (amount = this.getAmount(tool)) < neededPerLevel) {
            return name.m_6881_().m_130946_(": " + amount + " / " + neededPerLevel);
        }
        return name;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.getId());
    }

    public static int getAmount(IModDataView persistentData, Modifier modifier) {
        if (persistentData.contains(modifier.getId(), 99)) {
            return persistentData.getInt(modifier.getId());
        }
        return ModifierRecipeLookup.getNeededPerLevel(modifier);
    }

    public static int getAmount(IToolContext tool, Modifier modifier) {
        return IncrementalModifier.getAmount(tool.getPersistentData(), modifier);
    }

    public int getAmount(IModDataView persistentData) {
        return IncrementalModifier.getAmount(persistentData, (Modifier)this);
    }

    public int getAmount(IToolContext tool) {
        return IncrementalModifier.getAmount(tool, (Modifier)this);
    }

    public float getScaledLevel(IModDataView persistentData, int level) {
        if (level <= 0) {
            return 0.0f;
        }
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this);
        if (neededPerLevel > 0) {
            return (float)level + (float)(this.getAmount(persistentData) - neededPerLevel) / (float)neededPerLevel;
        }
        return level;
    }

    public float getScaledLevel(IToolContext tool, int level) {
        return this.getScaledLevel(tool.getPersistentData(), level);
    }

    public static void setAmount(ModDataNBT persistentData, Modifier modifier, int amount) {
        persistentData.putInt(modifier.getId(), amount);
    }

    protected void addDamageTooltip(IToolStackView tool, int level, float levelAmount, List<Component> tooltip) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) * levelAmount, tooltip);
    }
}

