/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ExtraModifier
extends Modifier {
    private final SlotType type;
    private final ModifierSource source;
    private final int slotsPerLevel;

    public ExtraModifier(SlotType type, ModifierSource source) {
        this(type, source, 1);
    }

    public ExtraModifier() {
        this(SlotType.UPGRADE, ModifierSource.SINGLE_LEVEL);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.source.alwaysShow() || advanced;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        volatileData.addSlots(this.type, level * this.slotsPerLevel);
    }

    @Override
    public Component getDisplayName(int level) {
        if (this.source.isSingleLevel() && level == 1) {
            return this.getDisplayName();
        }
        return super.getDisplayName(level);
    }

    @Override
    public int getPriority() {
        return this.source.isSingleLevel() ? 50 : 60;
    }

    public ExtraModifier(SlotType type, ModifierSource source, int slotsPerLevel) {
        this.type = type;
        this.source = source;
        this.slotsPerLevel = slotsPerLevel;
    }

    public static enum ModifierSource {
        SINGLE_LEVEL,
        MULTI_LEVEL,
        TRAIT;


        public boolean isSingleLevel() {
            return this == SINGLE_LEVEL;
        }

        public boolean alwaysShow() {
            return this == TRAIT;
        }
    }
}

