/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class TagIntersectionPresentCondition
implements ICondition {
    private static final ResourceLocation NAME = TConstruct.getResource("tag_intersection_present");
    public static final Serializer SERIALIZER = new Serializer();
    private final List<ResourceLocation> names;

    public TagIntersectionPresentCondition(ResourceLocation ... names) {
        this(Arrays.asList(names));
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        TagCollection itemTags = SerializationTags.m_13199_().m_144452_(Registry.f_122904_);
        List<Tag> tags = this.names.stream().map(arg_0 -> ((TagCollection)itemTags).m_7689_(arg_0)).toList();
        if (tags.size() == 1) {
            return !tags.get(0).m_6497_().isEmpty();
        }
        if (tags.stream().anyMatch(tag -> tag.m_6497_().isEmpty())) {
            return false;
        }
        int count = tags.size();
        block0: for (Item item : tags.get(0).m_6497_()) {
            for (int i = 1; i < count; ++i) {
                if (!tags.get(i).m_8110_((Object)item)) continue block0;
            }
            return true;
        }
        return false;
    }

    public TagIntersectionPresentCondition(List<ResourceLocation> names) {
        this.names = names;
    }

    private static class Serializer
    implements IConditionSerializer<TagIntersectionPresentCondition> {
        private Serializer() {
        }

        public void write(JsonObject json, TagIntersectionPresentCondition value) {
            JsonArray names = new JsonArray();
            for (ResourceLocation name : value.names) {
                names.add(name.toString());
            }
            json.add("tags", (JsonElement)names);
        }

        public TagIntersectionPresentCondition read(JsonObject json) {
            return new TagIntersectionPresentCondition(JsonHelper.parseList((JsonObject)json, (String)"tags", JsonHelper::convertToResourceLocation));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

