/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class LazyTag<T>
implements Tag.Named<T> {
    private final ResourceLocation name;
    @Nullable
    private ResourceKey<? extends Registry<T>> key;
    @Nullable
    private Tag<T> internal;

    public static <T> LazyTag<T> of(Tag.Named<T> named) {
        return new LazyTag<T>(named.m_6979_(), null, named);
    }

    public static <T> LazyTag<T> of(ResourceKey<? extends Registry<T>> key, ResourceLocation name) {
        return new LazyTag<T>(name, key, null);
    }

    public static <T> LazyTag<T> fromJson(ResourceKey<? extends Registry<T>> key, JsonObject parent, String jsonKey) {
        return LazyTag.of(key, JsonHelper.getResourceLocation((JsonObject)parent, (String)jsonKey));
    }

    public static <T> LazyTag<T> fromNetwork(ResourceKey<? extends Registry<T>> key, FriendlyByteBuf buffer) {
        return LazyTag.of(key, buffer.m_130281_());
    }

    @Nullable
    public static <T> LazyTag<T> fromNetworkOptional(ResourceKey<? extends Registry<T>> key, FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return LazyTag.of(key, buffer.m_130281_());
        }
        return null;
    }

    @Nullable
    private Tag<T> getTag() {
        if (this.internal == null) {
            if (this.key == null) {
                return null;
            }
            this.internal = SerializationTags.m_13199_().m_144452_(this.key).m_13404_(this.name);
            if (this.internal == null) {
                TConstruct.LOG.warn("Unknwon tag {} for registry {}", (Object)this.name, this.key);
            }
            this.key = null;
        }
        return this.internal;
    }

    public boolean m_8110_(T pValue) {
        Tag<T> tag = this.getTag();
        return tag != null && tag.m_8110_(pValue);
    }

    public List<T> m_6497_() {
        Tag<T> tag = this.getTag();
        return tag == null ? Collections.emptyList() : tag.m_6497_();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.name);
    }

    public static void toNetworkOptional(@Nullable LazyTag<?> tag, FriendlyByteBuf buffer) {
        if (tag != null) {
            buffer.writeBoolean(true);
            tag.toNetwork(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    protected LazyTag(ResourceLocation name, @Nullable ResourceKey<? extends Registry<T>> key, @Nullable Tag<T> internal) {
        this.name = name;
        this.key = key;
        this.internal = internal;
    }

    public ResourceLocation m_6979_() {
        return this.name;
    }
}

