/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class BreakableDyedModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = (Material)smallGetter.apply("");
        Material brokenSmall = (Material)smallGetter.apply("_broken");
        Material largeTexture = (Material)largeGetter.apply("");
        Material brokenLarge = (Material)largeGetter.apply("_broken");
        if (smallTexture != null || brokenSmall != null || largeTexture != null || brokenLarge != null) {
            return new BreakableDyedModifierModel(smallTexture, brokenSmall, largeTexture, brokenLarge);
        }
        return null;
    };
    private final Material[] textures;

    public BreakableDyedModifierModel(@Nullable Material normalSmall, @Nullable Material brokenSmall, @Nullable Material normalLarge, @Nullable Material brokenLarge) {
        this.textures = new Material[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        Modifier modifier = entry.getModifier();
        ModifierId key = modifier.getId();
        ModDataNBT data = tool.getPersistentData();
        int color = -1;
        if (data.contains(key, 3)) {
            color = data.getInt(modifier.getId());
        }
        return new CacheKey(modifier, color);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        ModifierId key;
        ModDataNBT data;
        Material texture = this.textures[(isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0)];
        if (texture != null && (data = tool.getPersistentData()).contains(key = modifier.getModifier().getId(), 3)) {
            return MantleItemLayerModel.getQuadsForSprite((int)(0xFF000000 | data.getInt(key)), (int)-1, (TextureAtlasSprite)spriteGetter.apply(texture), (Transformation)transforms, (int)0, (ItemLayerPixels)pixels);
        }
        return ImmutableList.of();
    }

    private record CacheKey(Modifier modifier, int color) {
    }
}

