/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.client.book.elements.CycleRecipeElement;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ContentModifier
extends PageContent {
    public static final transient ResourceLocation ID = TConstruct.getResource("modifier");
    public static final transient int TEX_SIZE = 256;
    public static final ResourceLocation BOOK_MODIFY = TConstruct.getResource("textures/gui/book/modify.png");
    private static final transient String KEY_EFFECTS = TConstruct.makeTranslationKey("book", "modifiers.effect");
    public static final transient ImageData IMG_SLOT_1 = new ImageData(BOOK_MODIFY, 0, 75, 22, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_2 = new ImageData(BOOK_MODIFY, 0, 97, 40, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_3 = new ImageData(BOOK_MODIFY, 0, 119, 58, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_4 = new ImageData(BOOK_MODIFY, 0, 141, 40, 40, 256, 256);
    public static final transient ImageData IMG_SLOT_5 = new ImageData(BOOK_MODIFY, 0, 181, 58, 41, 256, 256);
    public static final transient ImageData IMG_TABLE = new ImageData(BOOK_MODIFY, 214, 0, 42, 46, 256, 256);
    public static final transient ImageData[] IMG_SLOTS = new ImageData[]{IMG_SLOT_1, IMG_SLOT_2, IMG_SLOT_3, IMG_SLOT_4, IMG_SLOT_5};
    public static final transient int[] SLOTS_X = new int[]{3, 21, 39, 12, 30};
    public static final transient int[] SLOTS_Y = new int[]{3, 3, 3, 22, 22};
    public static final transient int[] SLOTS_X_4 = new int[]{3, 21, 3, 21};
    public static final transient int[] SLOTS_Y_4 = new int[]{3, 3, 22, 22};
    @Nullable
    private transient Modifier modifier;
    private transient List<IDisplayModifierRecipe> recipes;
    private transient int currentRecipe = 0;
    private final transient List<BookElement> parts = new ArrayList<BookElement>();
    public TextData[] text;
    public String[] effects;
    public boolean more_text_space = false;
    @SerializedName(value="required_mod")
    private String requiredMod = "";
    @SerializedName(value="modifier_id")
    public String modifierID;

    public Modifier getModifier() {
        if (this.modifier == null) {
            if (this.modifierID == null) {
                this.modifierID = this.parent.name;
            }
            this.modifier = Objects.requireNonNull((Modifier)TinkerRegistries.MODIFIERS.getValue((ResourceLocation)new ModifierId(this.modifierID)));
        }
        return this.modifier;
    }

    public String getTitle() {
        return this.getModifier().getDisplayName().getString();
    }

    public void load() {
        if (this.recipes == null) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            Modifier modifier = this.getModifier();
            this.recipes = modifier == TinkerModifiers.empty.get() ? Collections.emptyList() : RecipeHelper.getJEIRecipes((RecipeManager)Minecraft.m_91087_().f_91073_.m_7465_(), RecipeTypes.TINKER_STATION, IDisplayModifierRecipe.class).stream().filter(recipe -> recipe.getDisplayResult().getModifier() == modifier).collect(Collectors.toList());
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean brightSide) {
        Modifier modifier = this.getModifier();
        if (modifier == TinkerModifiers.empty.get() || this.recipes.isEmpty()) {
            list.add((BookElement)new ImageElement(0, 0, 32, 32, ImageData.MISSING));
            System.out.println("Modifier with id " + this.modifierID + " not found");
            return;
        }
        this.addTitle(list, this.getTitle(), true, modifier.getColor());
        int y = this.getTitleHeight();
        int h = this.more_text_space ? 70 : 50;
        list.add((BookElement)new TextElement(5, y, 172, h, this.text));
        if (this.effects.length > 0) {
            TextData head = new TextData(I18n.m_118938_((String)KEY_EFFECTS, (Object[])new Object[0]));
            head.underlined = true;
            list.add((BookElement)new TextElement(5, y + h, 86, 176 - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.effects) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new TextElement(5, y + 14 + h, 96, 176 - h - 20, (Collection)effectData));
        }
        if (this.recipes.size() > 1) {
            int col = book.appearance.structureButtonColor;
            int colHover = book.appearance.structureButtonColorHovered;
            list.add((BookElement)new CycleRecipeElement(182 - ArrowButton.ArrowType.RIGHT.w - 32, 160, ArrowButton.ArrowType.RIGHT, col, colHover, this, book, list));
        }
        this.buildAndAddRecipeDisplay(book, list, this.recipes.get(this.currentRecipe), null);
    }

    public void buildAndAddRecipeDisplay(BookData book, ArrayList<BookElement> list, @Nullable IDisplayModifierRecipe recipe, @Nullable BookScreen parent) {
        if (recipe != null) {
            List<List<ItemStack>> inputs = recipe.getDisplayItems();
            ImageData img = IMG_SLOTS[Math.min(inputs.size() - 2, 4)];
            if (inputs.size() > 6) {
                TConstruct.LOG.warn("Too many inputs in recipe {}, size {}", (Object)recipe, (Object)(inputs.size() - 2));
            }
            int[] slotsX = SLOTS_X;
            int[] slotsY = SLOTS_Y;
            if (inputs.size() == 5) {
                slotsX = SLOTS_X_4;
                slotsY = SLOTS_Y_4;
            }
            int imgX = 111;
            int imgY = 118;
            imgX = imgX + 29 - img.width / 2;
            imgY = imgY + 20 - img.height / 2;
            ImageElement table = new ImageElement(imgX + (img.width - ContentModifier.IMG_TABLE.width) / 2, imgY - 24, -1, -1, IMG_TABLE);
            if (parent != null) {
                table.parent = parent;
            }
            this.parts.add((BookElement)table);
            list.add((BookElement)table);
            ImageElement slot = new ImageElement(imgX, imgY, -1, -1, img, book.appearance.slotColor);
            if (parent != null) {
                slot.parent = parent;
            }
            this.parts.add((BookElement)slot);
            list.add((BookElement)slot);
            ItemStackList demo = this.getDemoTools(recipe.getToolWithModifier());
            TinkerItemElement demoTools = new TinkerItemElement(imgX + (img.width - 16) / 2, imgY - 24, 1.0f, (Collection<ItemStack>)demo);
            if (parent != null) {
                demoTools.parent = parent;
            }
            this.parts.add((BookElement)demoTools);
            list.add((BookElement)demoTools);
            ImageElement image = new ImageElement(imgX + (img.width - 22) / 2, imgY - 27, -1, -1, IMG_SLOT_1, 0xFFFFFF);
            if (parent != null) {
                image.parent = parent;
            }
            this.parts.add((BookElement)image);
            list.add((BookElement)image);
            for (int i = 1; i < Math.min(inputs.size(), 6); ++i) {
                TinkerItemElement part = new TinkerItemElement(imgX + slotsX[i - 1], imgY + slotsY[i - 1], 1.0f, (Collection<ItemStack>)inputs.get(i));
                if (parent != null) {
                    part.parent = parent;
                }
                this.parts.add((BookElement)part);
                list.add((BookElement)part);
            }
        }
    }

    protected ItemStackList getDemoTools(List<ItemStack> stacks) {
        ItemStackList demo = ItemStackList.withSize((int)stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            demo.set(i, (Object)stacks.get(i));
        }
        return demo;
    }

    public void nextRecipe(BookData book, ArrayList<BookElement> list) {
        ++this.currentRecipe;
        if (this.currentRecipe >= this.recipes.size()) {
            this.currentRecipe = 0;
        }
        BookScreen parent = this.parts.get((int)0).parent;
        for (BookElement element : this.parts) {
            list.remove(element);
        }
        this.parts.clear();
        this.buildAndAddRecipeDisplay(book, list, this.recipes.get(this.currentRecipe), parent);
    }
}

