/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.EffectRenderer;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.capability.PiggybackCapability;
import slimeknights.tconstruct.gadgets.capability.PiggybackHandler;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.client.RenderUtils;

public class PiggyBackPackItem
extends TooltipItem {
    private static final int MAX_ENTITY_STACK = 3;

    public PiggyBackPackItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        ItemStack chestArmor = playerIn.m_6844_(EquipmentSlot.CHEST);
        if (chestArmor.m_41720_() != this && playerIn.m_150109_().m_36062_() == -1) {
            return InteractionResult.PASS;
        }
        if (this.pickupEntity(playerIn, (Entity)target)) {
            if (chestArmor.m_41720_() != this) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)chestArmor);
                chestArmor = ItemStack.f_41583_;
            }
            if (chestArmor.m_41619_()) {
                playerIn.m_8061_(EquipmentSlot.CHEST, stack.m_41620_(1));
            } else if (chestArmor.m_41613_() < this.getEntitiesCarriedCount((LivingEntity)playerIn)) {
                stack.m_41620_(1);
                chestArmor.m_41769_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private boolean pickupEntity(Player player, Entity target) {
        int count;
        if (player.m_20193_().f_46443_ || TinkerTags.EntityTypes.PIGGYBACKPACK_BLACKLIST.m_8110_((Object)target.m_6095_())) {
            return false;
        }
        if (target.m_20202_() == player || player.m_20202_() == target) {
            return false;
        }
        Player toRide = player;
        for (count = 0; toRide.m_20160_() && count < 3; ++count) {
            toRide = (Entity)toRide.m_20197_().get(0);
            if (!(toRide instanceof Player) || !(target instanceof Player)) continue;
            return false;
        }
        if (!toRide.m_20160_() && count < 3 && target.m_7998_((Entity)toRide, true)) {
            if (player instanceof ServerPlayer) {
                TinkerNetwork.getInstance().sendVanillaPacket((Entity)player, (Packet<?>)new ClientboundSetPassengersPacket((Entity)player));
            }
            return true;
        }
        return false;
    }

    private int getEntitiesCarriedCount(LivingEntity player) {
        int count = 0;
        LivingEntity ridden = player;
        while (ridden.m_20160_()) {
            ++count;
            ridden = (Entity)ridden.m_20197_().get(0);
        }
        return count;
    }

    public void matchCarriedEntitiesToCount(LivingEntity player, int maxCount) {
        int count = 0;
        LivingEntity ridden = player;
        while (ridden.m_20160_()) {
            ridden = (Entity)ridden.m_20197_().get(0);
            if (++count <= maxCount) continue;
            ridden.m_8127_();
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LivingEntity livingEntity;
        if (entityIn instanceof LivingEntity && (livingEntity = (LivingEntity)entityIn).m_6844_(EquipmentSlot.CHEST) == stack && entityIn.m_20160_()) {
            int amplifier = this.getEntitiesCarriedCount(livingEntity) - 1;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)TinkerGadgets.carryEffect.get(), 2, amplifier, true, false));
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public static class CarryPotionEffect
    extends TinkerEffect {
        static final String UUID = "ff4de63a-2b24-11e6-b67b-9e71128cae77";

        public CarryPotionEffect() {
            super(MobEffectCategory.NEUTRAL, true);
            this.m_19472_(Attributes.f_22279_, UUID, -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        public void m_6742_(@Nonnull LivingEntity livingEntityIn, int p_76394_2_) {
            ItemStack chestArmor = livingEntityIn.m_6844_(EquipmentSlot.CHEST);
            if (chestArmor.m_41619_() || chestArmor.m_41720_() != TinkerGadgets.piggyBackpack.get()) {
                ((PiggyBackPackItem)TinkerGadgets.piggyBackpack.get()).matchCarriedEntitiesToCount(livingEntityIn, 0);
            } else {
                ((PiggyBackPackItem)TinkerGadgets.piggyBackpack.get()).matchCarriedEntitiesToCount(livingEntityIn, chestArmor.m_41613_());
                if (!livingEntityIn.m_20193_().f_46443_) {
                    livingEntityIn.getCapability(PiggybackCapability.PIGGYBACK, null).ifPresent(PiggybackHandler::updatePassengers);
                }
            }
        }

        @Override
        public void initializeClient(Consumer<EffectRenderer> consumer) {
            consumer.accept(new EffectRenderer(){

                public void renderInventoryEffect(MobEffectInstance effect, EffectRenderingInventoryScreen<?> gui, PoseStack matrices, int x, int y, float z) {
                    this.renderHUDEffect(effect, (GuiComponent)gui, matrices, x, y, z, 1.0f);
                }

                public void renderHUDEffect(MobEffectInstance effect, GuiComponent gui, PoseStack matrices, int x, int y, float z, float alpha) {
                    RenderUtils.setup(Icons.ICONS);
                    ElementScreen element = switch (effect.m_19564_()) {
                        case 0 -> Icons.PIGGYBACK_1;
                        case 1 -> Icons.PIGGYBACK_2;
                        default -> Icons.PIGGYBACK_3;
                    };
                    element.draw(matrices, x + 6, y + 7);
                }
            });
        }
    }
}

