/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import slimeknights.mantle.registration.ModelFluidAttributes;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.fluids.fluids.SlimeFluid;
import slimeknights.tconstruct.shared.block.SlimeType;

public final class TinkerFluids
extends TinkerModule {
    public static final FluidObject<ForgeFlowingFluid> blood = FLUIDS.register("blood", TinkerFluids.coolBuilder().density(1200).viscosity(1200).temperature(336), Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> venom = FLUIDS.register("venom", TinkerFluids.coolBuilder().density(1400).viscosity(1300).temperature(310), Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> earthSlime = FLUIDS.register("earth_slime", "slime", TinkerFluids.coolBuilder().density(1400).viscosity(1400).temperature(350), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> skySlime = FLUIDS.register("sky_slime", TinkerFluids.coolBuilder().density(1500).viscosity(1500).temperature(310), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> enderSlime = FLUIDS.register("ender_slime", TinkerFluids.coolBuilder().density(1600).viscosity(1600).temperature(370), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> magma = FLUIDS.register("magma", TinkerFluids.coolBuilder().density(1900).viscosity(1900).temperature(600), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 3);
    public static final Map<SlimeType, FluidObject<ForgeFlowingFluid>> slime = new EnumMap<SlimeType, FluidObject<ForgeFlowingFluid>>(SlimeType.class);
    public static final FluidObject<ForgeFlowingFluid> searedStone;
    public static final FluidObject<ForgeFlowingFluid> scorchedStone;
    public static final FluidObject<ForgeFlowingFluid> moltenClay;
    public static final FluidObject<ForgeFlowingFluid> moltenGlass;
    public static final FluidObject<ForgeFlowingFluid> liquidSoul;
    public static final FluidObject<ForgeFlowingFluid> moltenPorcelain;
    public static final FluidObject<ForgeFlowingFluid> moltenObsidian;
    public static final FluidObject<ForgeFlowingFluid> moltenEnder;
    public static final FluidObject<ForgeFlowingFluid> blazingBlood;
    public static final FluidObject<ForgeFlowingFluid> moltenEmerald;
    public static final FluidObject<ForgeFlowingFluid> moltenQuartz;
    public static final FluidObject<ForgeFlowingFluid> moltenAmethyst;
    public static final FluidObject<ForgeFlowingFluid> moltenDiamond;
    public static final FluidObject<ForgeFlowingFluid> moltenDebris;
    public static final FluidObject<ForgeFlowingFluid> moltenIron;
    public static final FluidObject<ForgeFlowingFluid> moltenGold;
    public static final FluidObject<ForgeFlowingFluid> moltenCopper;
    public static final FluidObject<ForgeFlowingFluid> moltenCobalt;
    public static final FluidObject<ForgeFlowingFluid> moltenSlimesteel;
    public static final FluidObject<ForgeFlowingFluid> moltenTinkersBronze;
    public static final FluidObject<ForgeFlowingFluid> moltenRoseGold;
    public static final FluidObject<ForgeFlowingFluid> moltenPigIron;
    public static final FluidObject<ForgeFlowingFluid> moltenManyullyn;
    public static final FluidObject<ForgeFlowingFluid> moltenHepatizon;
    public static final FluidObject<ForgeFlowingFluid> moltenQueensSlime;
    public static final FluidObject<ForgeFlowingFluid> moltenSoulsteel;
    public static final FluidObject<ForgeFlowingFluid> moltenNetherite;
    public static final FluidObject<ForgeFlowingFluid> moltenKnightslime;
    public static final FluidObject<ForgeFlowingFluid> moltenTin;
    public static final FluidObject<ForgeFlowingFluid> moltenAluminum;
    public static final FluidObject<ForgeFlowingFluid> moltenLead;
    public static final FluidObject<ForgeFlowingFluid> moltenSilver;
    public static final FluidObject<ForgeFlowingFluid> moltenNickel;
    public static final FluidObject<ForgeFlowingFluid> moltenZinc;
    public static final FluidObject<ForgeFlowingFluid> moltenPlatinum;
    public static final FluidObject<ForgeFlowingFluid> moltenTungsten;
    public static final FluidObject<ForgeFlowingFluid> moltenOsmium;
    public static final FluidObject<ForgeFlowingFluid> moltenUranium;
    public static final FluidObject<ForgeFlowingFluid> moltenBronze;
    public static final FluidObject<ForgeFlowingFluid> moltenBrass;
    public static final FluidObject<ForgeFlowingFluid> moltenElectrum;
    public static final FluidObject<ForgeFlowingFluid> moltenInvar;
    public static final FluidObject<ForgeFlowingFluid> moltenConstantan;
    public static final FluidObject<ForgeFlowingFluid> moltenPewter;
    public static final FluidObject<ForgeFlowingFluid> moltenSteel;
    public static final FluidObject<ForgeFlowingFluid> moltenEnderium;
    public static final FluidObject<ForgeFlowingFluid> moltenLumium;
    public static final FluidObject<ForgeFlowingFluid> moltenSignalum;
    public static final FluidObject<ForgeFlowingFluid> moltenRefinedGlowstone;
    public static final FluidObject<ForgeFlowingFluid> moltenRefinedObsidian;

    public TinkerFluids() {
        ForgeMod.enableMilkFluid();
    }

    private static FluidAttributes.Builder coolBuilder() {
        return ModelFluidAttributes.builder().sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
    }

    private static FluidAttributes.Builder hotBuilder() {
        return ModelFluidAttributes.builder().density(2000).viscosity(10000).temperature(1000).sound(SoundEvents.f_11783_, SoundEvents.f_11780_);
    }

    static {
        slime.put(SlimeType.EARTH, earthSlime);
        slime.put(SlimeType.SKY, skySlime);
        slime.put(SlimeType.ENDER, enderSlime);
        slime.put(SlimeType.BLOOD, blood);
        searedStone = FLUIDS.register("seared_stone", TinkerFluids.hotBuilder().temperature(900), Material.f_76307_, 6);
        scorchedStone = FLUIDS.register("scorched_stone", TinkerFluids.hotBuilder().temperature(800), Material.f_76307_, 4);
        moltenClay = FLUIDS.register("molten_clay", TinkerFluids.hotBuilder().temperature(750), Material.f_76307_, 3);
        moltenGlass = FLUIDS.register("molten_glass", TinkerFluids.hotBuilder().temperature(1050), Material.f_76307_, 1);
        liquidSoul = FLUIDS.register("liquid_soul", TinkerFluids.hotBuilder().temperature(700), Material.f_76307_, 2);
        moltenPorcelain = FLUIDS.register("molten_porcelain", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 2);
        moltenObsidian = FLUIDS.register("molten_obsidian", TinkerFluids.hotBuilder().temperature(1300), Material.f_76307_, 3);
        moltenEnder = FLUIDS.register("molten_ender", "ender", TinkerFluids.hotBuilder().temperature(777), Material.f_76307_, 5);
        blazingBlood = FLUIDS.register("blazing_blood", TinkerFluids.hotBuilder().temperature(1800).density(3500), Material.f_76307_, 15);
        moltenEmerald = FLUIDS.register("molten_emerald", TinkerFluids.hotBuilder().temperature(1234), Material.f_76307_, 9);
        moltenQuartz = FLUIDS.register("molten_quartz", TinkerFluids.hotBuilder().temperature(937), Material.f_76307_, 6);
        moltenAmethyst = FLUIDS.register("molten_amethyst", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 11);
        moltenDiamond = FLUIDS.register("molten_diamond", TinkerFluids.hotBuilder().temperature(1750), Material.f_76307_, 13);
        moltenDebris = FLUIDS.register("molten_debris", TinkerFluids.hotBuilder().temperature(1475), Material.f_76307_, 14);
        moltenIron = FLUIDS.register("molten_iron", TinkerFluids.hotBuilder().temperature(1100), Material.f_76307_, 12);
        moltenGold = FLUIDS.register("molten_gold", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 12);
        moltenCopper = FLUIDS.register("molten_copper", TinkerFluids.hotBuilder().temperature(800), Material.f_76307_, 12);
        moltenCobalt = FLUIDS.register("molten_cobalt", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 8);
        moltenSlimesteel = FLUIDS.register("molten_slimesteel", TinkerFluids.hotBuilder().temperature(1200), Material.f_76307_, 10);
        moltenTinkersBronze = FLUIDS.register("molten_tinkers_bronze", "molten_silicon_bronze", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 12);
        moltenRoseGold = FLUIDS.register("molten_rose_gold", TinkerFluids.hotBuilder().temperature(850), Material.f_76307_, 12);
        moltenPigIron = FLUIDS.register("molten_pig_iron", TinkerFluids.hotBuilder().temperature(1111), Material.f_76307_, 10);
        moltenManyullyn = FLUIDS.register("molten_manyullyn", TinkerFluids.hotBuilder().temperature(1500), Material.f_76307_, 11);
        moltenHepatizon = FLUIDS.register("molten_hepatizon", TinkerFluids.hotBuilder().temperature(1700), Material.f_76307_, 8);
        moltenQueensSlime = FLUIDS.register("molten_queens_slime", TinkerFluids.hotBuilder().temperature(1450), Material.f_76307_, 9);
        moltenSoulsteel = FLUIDS.register("molten_soulsteel", TinkerFluids.hotBuilder().temperature(1500), Material.f_76307_, 6);
        moltenNetherite = FLUIDS.register("molten_netherite", TinkerFluids.hotBuilder().temperature(1550), Material.f_76307_, 14);
        moltenKnightslime = FLUIDS.register("molten_knightslime", TinkerFluids.hotBuilder().temperature(1425), Material.f_76307_, 12);
        moltenTin = FLUIDS.register("molten_tin", TinkerFluids.hotBuilder().temperature(525), Material.f_76307_, 12);
        moltenAluminum = FLUIDS.register("molten_aluminum", TinkerFluids.hotBuilder().temperature(725), Material.f_76307_, 12);
        moltenLead = FLUIDS.register("molten_lead", TinkerFluids.hotBuilder().temperature(630), Material.f_76307_, 12);
        moltenSilver = FLUIDS.register("molten_silver", TinkerFluids.hotBuilder().temperature(1090), Material.f_76307_, 12);
        moltenNickel = FLUIDS.register("molten_nickel", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 12);
        moltenZinc = FLUIDS.register("molten_zinc", TinkerFluids.hotBuilder().temperature(720), Material.f_76307_, 12);
        moltenPlatinum = FLUIDS.register("molten_platinum", TinkerFluids.hotBuilder().temperature(1270), Material.f_76307_, 12);
        moltenTungsten = FLUIDS.register("molten_tungsten", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 12);
        moltenOsmium = FLUIDS.register("molten_osmium", TinkerFluids.hotBuilder().temperature(1275), Material.f_76307_, 4);
        moltenUranium = FLUIDS.register("molten_uranium", TinkerFluids.hotBuilder().temperature(1130), Material.f_76307_, 15);
        moltenBronze = FLUIDS.register("molten_bronze", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 10);
        moltenBrass = FLUIDS.register("molten_brass", TinkerFluids.hotBuilder().temperature(905), Material.f_76307_, 10);
        moltenElectrum = FLUIDS.register("molten_electrum", TinkerFluids.hotBuilder().temperature(1060), Material.f_76307_, 10);
        moltenInvar = FLUIDS.register("molten_invar", TinkerFluids.hotBuilder().temperature(1200), Material.f_76307_, 10);
        moltenConstantan = FLUIDS.register("molten_constantan", TinkerFluids.hotBuilder().temperature(1220), Material.f_76307_, 10);
        moltenPewter = FLUIDS.register("molten_pewter", TinkerFluids.hotBuilder().temperature(700), Material.f_76307_, 10);
        moltenSteel = FLUIDS.register("molten_steel", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 13);
        moltenEnderium = FLUIDS.register("molten_enderium", TinkerFluids.hotBuilder().temperature(1650), Material.f_76307_, 12);
        moltenLumium = FLUIDS.register("molten_lumium", TinkerFluids.hotBuilder().temperature(1350), Material.f_76307_, 15);
        moltenSignalum = FLUIDS.register("molten_signalum", TinkerFluids.hotBuilder().temperature(1425), Material.f_76307_, 13);
        moltenRefinedGlowstone = FLUIDS.register("molten_refined_glowstone", TinkerFluids.hotBuilder().temperature(1125), Material.f_76307_, 15);
        moltenRefinedObsidian = FLUIDS.register("molten_refined_obsidian", TinkerFluids.hotBuilder().temperature(1775), Material.f_76307_, 7);
    }
}

