/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.deferred.BlockDeferredRegister;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.world.block.BuddingCrystalBlock;
import slimeknights.tconstruct.world.block.CrystalBlock;
import slimeknights.tconstruct.world.block.CrystalClusterBlock;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;

public class GeodeItemObject
extends ItemObject<Item> {
    private final Supplier<? extends Block> block;
    private final Supplier<? extends Block> budding;
    private final Supplier<? extends Block> cluster;
    private final Supplier<? extends Block> smallBud;
    private final Supplier<? extends Block> mediumBud;
    private final Supplier<? extends Block> largeBud;
    private ConfiguredFeature<GeodeConfiguration, ?> configuredGeode;
    private PlacedFeature placedGeode;

    public GeodeItemObject(RegistryObject<? extends Item> shard, BlockDeferredRegister register, MaterialColor color, SoundType blockSound, SoundEvent chimeSound, Map<BudSize, SoundType> clusterSounds, int baseLight, Item.Properties props) {
        super(shard);
        IntFunction<ToIntFunction> light = extra -> {
            int calculated = Math.min(extra + baseLight, 15);
            return state -> calculated;
        };
        String name = shard.getId().m_135815_();
        Function<Block, BlockItem> blockItem = block -> new BlockItem(block, props);
        ToIntFunction crystalLight = light.apply(0);
        this.block = register.register(name + "_block", () -> new CrystalBlock(chimeSound, BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60953_(crystalLight).m_60978_(1.5f).m_60918_(blockSound).m_60999_()), blockItem);
        this.budding = register.register("budding_" + name, () -> new BuddingCrystalBlock(this, chimeSound, BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60977_().m_60953_(crystalLight).m_60978_(1.5f).m_60918_(blockSound).m_60999_()), blockItem);
        Supplier<BlockBehaviour.Properties> budProps = () -> BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60955_().m_60978_(1.5f);
        this.cluster = register.register(name + "_cluster", () -> new CrystalClusterBlock(chimeSound, 7, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(5)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.CLUSTER))), blockItem);
        this.smallBud = register.register("small_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 3, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(1)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.SMALL))), blockItem);
        this.mediumBud = register.register("medium_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 4, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(2)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.MEDIUM))), blockItem);
        this.largeBud = register.register("large_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 5, 3, ((BlockBehaviour.Properties)budProps.get()).m_60953_((ToIntFunction)light.apply(4)).m_60918_((SoundType)clusterSounds.get((Object)BudSize.LARGE))), blockItem);
    }

    public Block getBlock() {
        return this.block.get();
    }

    public Block getBudding() {
        return this.budding.get();
    }

    public Block getBud(BudSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case BudSize.SMALL -> this.smallBud.get();
            case BudSize.MEDIUM -> this.mediumBud.get();
            case BudSize.LARGE -> this.largeBud.get();
            case BudSize.CLUSTER -> this.cluster.get();
        };
    }

    public ConfiguredFeature<GeodeConfiguration, ?> configureGeode(BlockStateProvider middleLayer, BlockStateProvider outerLayer, GeodeLayerSettings layerSettings, GeodeCrackSettings crackSettings, IntProvider outerWall, IntProvider distributionPoints, IntProvider pointOffset, int genOffset, int invalidBlocks) {
        if (this.configuredGeode != null) {
            throw new IllegalStateException("Geode is already configured");
        }
        this.configuredGeode = Feature.f_159728_.m_65815_((FeatureConfiguration)new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (BlockStateProvider)SupplierBlockStateProvider.ofBlock(this.block), (BlockStateProvider)SupplierBlockStateProvider.ofBlock(this.budding), middleLayer, outerLayer, List.of(this.smallBud.get().m_49966_(), this.mediumBud.get().m_49966_(), this.largeBud.get().m_49966_(), this.cluster.get().m_49966_()), BlockTags.f_144287_.m_6979_(), BlockTags.f_144289_.m_6979_()), layerSettings, crackSettings, 0.335, 0.083, true, outerWall, distributionPoints, pointOffset, -genOffset, genOffset, 0.05, invalidBlocks));
        return this.configuredGeode;
    }

    public ConfiguredFeature<GeodeConfiguration, ?> getConfiguredGeode() {
        return Objects.requireNonNull(this.configuredGeode);
    }

    public PlacedFeature placeGeode(RarityFilter rarity, HeightRangePlacement height) {
        if (this.placedGeode != null) {
            throw new IllegalStateException("Geode is already placed");
        }
        this.placedGeode = this.getConfiguredGeode().m_190823_(new PlacementModifier[]{rarity, InSquarePlacement.m_191715_(), height, BiomeFilter.m_191561_()});
        return this.placedGeode;
    }

    public PlacedFeature getPlacedGeode() {
        return Objects.requireNonNull(this.placedGeode);
    }

    public static enum BudSize {
        SMALL,
        MEDIUM,
        LARGE,
        CLUSTER;

        public static final BudSize[] SIZES;
        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final int size = this.ordinal() + 1;

        public BudSize getNext() {
            return switch (this) {
                case SMALL -> MEDIUM;
                case MEDIUM -> LARGE;
                case LARGE -> CLUSTER;
                default -> SMALL;
            };
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        static {
            SIZES = new BudSize[]{SMALL, MEDIUM, LARGE};
        }
    }
}

