/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.tags;

import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class ItemTagProvider
extends ItemTagsProvider {
    public ItemTagProvider(DataGenerator generatorIn, BlockTagsProvider blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn, blockTagProvider, "tconstruct", existingFileHelper);
    }

    protected void m_6577_() {
        this.addCommon();
        this.addWorld();
        this.addSmeltery();
        this.addTools();
    }

    private void addCommon() {
        this.m_126548_((Tag.Named)TinkerTags.Items.TINKERS_GUIDES).m_126584_((Object[])new Item[]{(Item)TinkerCommons.materialsAndYou.get(), (Item)TinkerCommons.tinkersGadgetry.get(), (Item)TinkerCommons.punySmelting.get(), (Item)TinkerCommons.mightySmelting.get(), (Item)TinkerCommons.fantasticFoundry.get(), (Item)TinkerCommons.encyclopedia.get()});
        this.m_126548_(ItemTags.f_13162_).m_126580_(TinkerTags.Items.TINKERS_GUIDES);
        this.m_126548_((Tag.Named)TinkerTags.Items.GUIDEBOOKS).m_126580_(TinkerTags.Items.TINKERS_GUIDES);
        this.m_126548_((Tag.Named)TinkerTags.Items.BOOKS).m_126580_(TinkerTags.Items.GUIDEBOOKS);
        TagsProvider.TagAppender slimeballs = this.m_126548_((Tag.Named)Tags.Items.SLIMEBALLS);
        for (SlimeType slimeType : SlimeType.values()) {
            slimeballs.m_126580_(slimeType.getSlimeballTag());
        }
        TinkerCommons.slimeball.forEach((type, ball) -> this.m_126548_((Tag.Named)type.getSlimeballTag()).m_126582_(ball));
        this.m_126548_((Tag.Named)Tags.Items.INGOTS).m_126584_((Object[])new Item[]{(Item)TinkerSmeltery.searedBrick.get(), (Item)TinkerSmeltery.scorchedBrick.get()}).m_126580_(TinkerTags.Items.INGOTS_NETHERITE_SCRAP);
        this.m_126548_((Tag.Named)Tags.Items.NUGGETS).addTags(new Tag.Named[]{TinkerTags.Items.NUGGETS_COPPER, TinkerTags.Items.NUGGETS_NETHERITE, TinkerTags.Items.NUGGETS_NETHERITE_SCRAP});
        this.m_126548_((Tag.Named)TinkerTags.Items.WITHER_BONES).m_126582_((Object)((Item)TinkerMaterials.necroticBone.get()));
        this.m_126548_((Tag.Named)TinkerTags.Items.NUGGETS_COPPER).m_126582_((Object)((Item)TinkerMaterials.copperNugget.get()));
        this.m_126548_((Tag.Named)TinkerTags.Items.INGOTS_NETHERITE_SCRAP).m_126582_((Object)Items.f_42419_);
        this.m_126548_((Tag.Named)TinkerTags.Items.NUGGETS_NETHERITE).m_126582_((Object)((Item)TinkerMaterials.netheriteNugget.get()));
        this.m_126548_((Tag.Named)TinkerTags.Items.NUGGETS_NETHERITE_SCRAP).m_126582_((Object)((Item)TinkerMaterials.debrisNugget.get()));
        this.m_126548_((Tag.Named)Tags.Items.STORAGE_BLOCKS_COPPER).remove((Object)Blocks.f_152510_.m_5456_());
        this.addMetalTags(TinkerMaterials.cobalt);
        this.addMetalTags(TinkerMaterials.slimesteel);
        this.addMetalTags(TinkerMaterials.tinkersBronze);
        this.addMetalTags(TinkerMaterials.roseGold);
        this.addMetalTags(TinkerMaterials.pigIron);
        this.addMetalTags(TinkerMaterials.queensSlime);
        this.addMetalTags(TinkerMaterials.manyullyn);
        this.addMetalTags(TinkerMaterials.hepatizon);
        this.addMetalTags(TinkerMaterials.soulsteel);
        this.addMetalTags(TinkerMaterials.knightslime);
        this.m_126533_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS, (Tag.Named)Tags.Items.STORAGE_BLOCKS);
        this.m_126533_((Tag.Named)Tags.Blocks.GLASS_COLORLESS, (Tag.Named)Tags.Items.GLASS_COLORLESS);
        this.m_126533_((Tag.Named)Tags.Blocks.GLASS_PANES_COLORLESS, (Tag.Named)Tags.Items.GLASS_PANES_COLORLESS);
        this.m_126533_((Tag.Named)Tags.Blocks.STAINED_GLASS, (Tag.Named)Tags.Items.STAINED_GLASS);
        this.m_126533_((Tag.Named)Tags.Blocks.STAINED_GLASS_PANES, (Tag.Named)Tags.Items.STAINED_GLASS_PANES);
        for (SlimeType slimeType : DyeColor.values()) {
            ResourceLocation name = new ResourceLocation("forge", "glass/" + slimeType.m_7912_());
            this.m_126533_((Tag.Named)BlockTags.createOptional((ResourceLocation)name), (Tag.Named)ItemTags.createOptional((ResourceLocation)name));
            name = new ResourceLocation("forge", "glass_panes/" + slimeType.m_7912_());
            this.m_126533_((Tag.Named)BlockTags.createOptional((ResourceLocation)name), (Tag.Named)ItemTags.createOptional((ResourceLocation)name));
        }
        this.m_126533_((Tag.Named)TinkerTags.Blocks.WORKBENCHES, (Tag.Named)TinkerTags.Items.WORKBENCHES);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.TABLES, (Tag.Named)TinkerTags.Items.TABLES);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.ANVIL_METAL, (Tag.Named)TinkerTags.Items.ANVIL_METAL);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.PLANKLIKE, (Tag.Named)TinkerTags.Items.PLANKLIKE);
        TagsProvider.TagAppender slimeslings = this.m_126548_((Tag.Named)TinkerTags.Items.SLIMESLINGS);
        TinkerGadgets.slimeSling.values().forEach(arg_0 -> ((TagsProvider.TagAppender)slimeslings).m_126582_(arg_0));
        this.m_126548_(ItemTags.f_13151_).m_126584_((Object[])new Item[]{(Item)TinkerModifiers.goldReinforcement.get(), (Item)TinkerGadgets.itemFrame.get((Enum)FrameType.GOLD), (Item)TinkerGadgets.itemFrame.get((Enum)FrameType.REVERSED_GOLD), TinkerFluids.moltenGold.m_5456_(), TinkerCommons.goldBars.m_5456_(), TinkerCommons.goldPlatform.m_5456_()}).m_126580_(TinkerTags.Items.GOLD_CASTS);
        this.m_126548_(ItemTags.f_13150_).m_126582_((Object)((Item)TinkerWorld.headItems.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN)));
        this.m_126548_(ItemTags.f_13164_).addTags(new Tag.Named[]{TinkerMaterials.cobalt.getIngotTag(), TinkerMaterials.queensSlime.getIngotTag(), TinkerMaterials.manyullyn.getIngotTag(), TinkerMaterials.hepatizon.getIngotTag()});
        this.m_126533_((Tag.Named)TinkerTags.Blocks.COPPER_PLATFORMS, (Tag.Named)TinkerTags.Items.COPPER_PLATFORMS);
    }

    private void addWorld() {
        TagsProvider.TagAppender heads = this.m_126548_((Tag.Named)Tags.Items.HEADS);
        TinkerWorld.heads.forEach(head -> heads.m_126582_((Object)head.m_5456_()));
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SLIME_BLOCK, (Tag.Named)TinkerTags.Items.SLIME_BLOCK);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.CONGEALED_SLIME, (Tag.Named)TinkerTags.Items.CONGEALED_SLIME);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SLIMY_LOGS, (Tag.Named)TinkerTags.Items.SLIMY_LOGS);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SLIMY_PLANKS, (Tag.Named)TinkerTags.Items.SLIMY_PLANKS);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SLIMY_LEAVES, (Tag.Named)TinkerTags.Items.SLIMY_LEAVES);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SLIMY_SAPLINGS, (Tag.Named)TinkerTags.Items.SLIMY_SAPLINGS);
        this.m_126533_(BlockTags.f_13035_, ItemTags.f_13143_);
        this.m_126533_(BlockTags.f_13104_, ItemTags.f_13180_);
        this.m_126533_((Tag.Named)Tags.Blocks.ORES, (Tag.Named)Tags.Items.ORES);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.ORES_COBALT, (Tag.Named)TinkerTags.Items.ORES_COBALT);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.RAW_BLOCK_COBALT, (Tag.Named)TinkerTags.Items.RAW_BLOCK_COBALT);
        this.m_126548_((Tag.Named)TinkerTags.Items.RAW_COBALT).m_126582_((Object)((Item)TinkerWorld.rawCobalt.get()));
        this.m_126533_(BlockTags.f_13044_, ItemTags.f_13153_);
        this.m_126533_(BlockTags.f_13090_, ItemTags.f_13168_);
        this.m_126533_(BlockTags.f_13097_, ItemTags.f_13175_);
        this.m_126533_(BlockTags.f_13096_, ItemTags.f_13174_);
        this.m_126533_((Tag.Named)TinkerWorld.greenheart.getLogBlockTag(), (Tag.Named)TinkerWorld.greenheart.getLogItemTag());
        this.m_126533_((Tag.Named)TinkerWorld.skyroot.getLogBlockTag(), (Tag.Named)TinkerWorld.skyroot.getLogItemTag());
        this.m_126533_((Tag.Named)TinkerWorld.bloodshroom.getLogBlockTag(), (Tag.Named)TinkerWorld.bloodshroom.getLogItemTag());
        this.m_126533_(BlockTags.f_13106_, ItemTags.f_13182_);
        this.m_126533_(BlockTags.f_13105_, ItemTags.f_13181_);
        this.m_126533_(BlockTags.f_13098_, ItemTags.f_13176_);
        this.m_126533_((Tag.Named)Tags.Blocks.FENCES_WOODEN, (Tag.Named)Tags.Items.FENCES_WOODEN);
        this.m_126533_((Tag.Named)Tags.Blocks.FENCE_GATES_WOODEN, (Tag.Named)Tags.Items.FENCE_GATES_WOODEN);
        this.m_126533_(BlockTags.f_13095_, ItemTags.f_13173_);
        this.m_126533_(BlockTags.f_13102_, ItemTags.f_13178_);
        this.m_126533_(BlockTags.f_13092_, ItemTags.f_13170_);
        this.m_126533_(BlockTags.f_13100_, ItemTags.f_13177_);
        this.m_126533_(BlockTags.f_13066_, ItemTags.f_13157_);
    }

    private void addTools() {
        this.addToolTags((ItemLike)TinkerTools.pickaxe, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.STONE_HARVEST, TinkerTags.Items.MELEE, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.sledgeHammer, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.STONE_HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.TWO_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.veinHammer, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.STONE_HARVEST, TinkerTags.Items.MELEE, TinkerTags.Items.TWO_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.mattock, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.pickadze, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.AOE, TinkerTags.Items.STONE_HARVEST});
        this.addToolTags((ItemLike)TinkerTools.excavator, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE, TinkerTags.Items.TWO_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.handAxe, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.broadAxe, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.TWO_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.kama, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.scythe, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST_PRIMARY, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.TWO_HANDED, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.dagger, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.ONE_HANDED});
        this.addToolTags((ItemLike)TinkerTools.sword, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.SWORD, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.cleaver, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL, TinkerTags.Items.DURABILITY, TinkerTags.Items.HARVEST, TinkerTags.Items.MELEE_PRIMARY, TinkerTags.Items.TWO_HANDED, TinkerTags.Items.SWORD, TinkerTags.Items.AOE});
        this.addToolTags((ItemLike)TinkerTools.flintAndBronze, (Tag.Named<Item>[])new Tag.Named[]{TinkerTags.Items.DURABILITY, TinkerTags.Items.MELEE, TinkerTags.Items.ONE_HANDED, TinkerTags.Items.AOE});
        this.addArmorTags(TinkerTools.travelersGear, new Tag.Named[]{TinkerTags.Items.DURABILITY});
        this.addArmorTags(TinkerTools.plateArmor, new Tag.Named[]{TinkerTags.Items.DURABILITY});
        this.addArmorTags(TinkerTools.slimesuit, new Tag.Named[]{TinkerTags.Items.DURABILITY});
        this.addToolTags((ItemLike)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET), new Tag.Named[]{TinkerTags.Items.MULTIPART_TOOL});
        this.m_126548_((Tag.Named)TinkerTags.Items.HARVEST).m_126580_(TinkerTags.Items.HARVEST_PRIMARY).m_126580_(TinkerTags.Items.STONE_HARVEST);
        this.m_126548_((Tag.Named)TinkerTags.Items.MELEE).m_126580_(TinkerTags.Items.MELEE_PRIMARY).m_126580_(TinkerTags.Items.SWORD);
        this.m_126548_((Tag.Named)TinkerTags.Items.MELEE_OR_HARVEST).m_126580_(TinkerTags.Items.MELEE).m_126580_(TinkerTags.Items.HARVEST);
        this.m_126548_((Tag.Named)TinkerTags.Items.MELEE_OR_UNARMED).m_126580_(TinkerTags.Items.MELEE).m_126580_(TinkerTags.Items.CHESTPLATES);
        this.m_126548_((Tag.Named)TinkerTags.Items.HELD).m_126580_(TinkerTags.Items.ONE_HANDED).m_126580_(TinkerTags.Items.TWO_HANDED);
        this.m_126548_((Tag.Named)TinkerTags.Items.INTERACTABLE).m_126580_(TinkerTags.Items.HELD).m_126580_(TinkerTags.Items.CHESTPLATES);
        this.m_126548_((Tag.Named)TinkerTags.Items.ARMOR).m_126580_(TinkerTags.Items.BOOTS).m_126580_(TinkerTags.Items.LEGGINGS).m_126580_(TinkerTags.Items.CHESTPLATES).m_126580_(TinkerTags.Items.HELMETS);
        this.m_126548_((Tag.Named)TinkerTags.Items.AOE).m_126580_(TinkerTags.Items.BOOTS);
        this.m_126548_((Tag.Named)TinkerTags.Items.MODIFIABLE).m_126580_(TinkerTags.Items.MULTIPART_TOOL).m_126580_(TinkerTags.Items.DURABILITY).m_126580_(TinkerTags.Items.MELEE_OR_HARVEST).m_126580_(TinkerTags.Items.AOE).m_126580_(TinkerTags.Items.HELD);
        this.m_126548_((Tag.Named)Tags.Items.SHEARS).m_126582_((Object)((Item)TinkerTools.kama.get()));
        this.m_126548_((Tag.Named)TinkerTags.Items.SCYTHES).m_126584_((Object[])new Item[]{(Item)TinkerTools.kama.get(), (Item)TinkerTools.scythe.get()});
        this.m_126548_((Tag.Named)TinkerTags.Items.AUTOSMELT_BLACKLIST);
        this.m_126548_((Tag.Named)TinkerTags.Items.SEEDS).m_126580_((Tag.Named)Tags.Items.SEEDS).m_126584_((Object[])new Item[]{Items.f_42619_, Items.f_42620_, Items.f_42588_});
        this.m_126533_((Tag.Named)TinkerTags.Blocks.CHRYSOPHILITE_ORES, (Tag.Named)TinkerTags.Items.CHRYSOPHILITE_ORES);
        this.m_126548_((Tag.Named)TinkerTags.Items.TOOL_PARTS).m_126584_((Object[])new Item[]{(Item)TinkerToolParts.pickHead.get(), (Item)TinkerToolParts.hammerHead.get(), (Item)TinkerToolParts.smallAxeHead.get(), (Item)TinkerToolParts.broadAxeHead.get(), (Item)TinkerToolParts.smallBlade.get(), (Item)TinkerToolParts.broadBlade.get(), (Item)TinkerToolParts.toolBinding.get(), (Item)TinkerToolParts.roundPlate.get(), (Item)TinkerToolParts.largePlate.get(), (Item)TinkerToolParts.toolHandle.get(), (Item)TinkerToolParts.toughHandle.get(), (Item)TinkerToolParts.repairKit.get()});
        TagsProvider.TagAppender slimySeeds = this.m_126548_((Tag.Named)TinkerTags.Items.SLIMY_SEEDS);
        TinkerWorld.slimeGrassSeeds.values().forEach(arg_0 -> ((TagsProvider.TagAppender)slimySeeds).m_126582_(arg_0));
        this.m_126548_((Tag.Named)TinkerTags.Items.STONESHIELDS).m_126580_((Tag.Named)Tags.Items.STONE).m_126580_((Tag.Named)Tags.Items.COBBLESTONE).m_126580_((Tag.Named)Tags.Items.SANDSTONE).m_126580_((Tag.Named)Tags.Items.END_STONES).m_126580_((Tag.Named)Tags.Items.GRAVEL).m_126584_((Object[])new Item[]{Items.f_42048_, Items.f_42051_, Items.f_42052_, Items.f_42755_, Items.f_42759_});
        this.m_126548_((Tag.Named)TinkerTags.Items.FIREBALLS).m_126582_((Object)Items.f_42613_);
        this.m_126548_((Tag.Named)TinkerTags.Items.TOOL_INVENTORY_BLACKLIST).m_126584_((Object[])new Item[]{Items.f_42265_, Items.f_42266_, Items.f_42267_, Items.f_42268_, Items.f_42269_, Items.f_42270_, Items.f_42271_, Items.f_42272_, Items.f_42273_, Items.f_42274_, Items.f_42275_, Items.f_42224_, Items.f_42225_, Items.f_42226_, Items.f_42227_, Items.f_42228_, Items.f_42229_});
        this.m_126548_((Tag.Named)TinkerTags.Items.VARIANT_PLANKS).m_126584_((Object[])new Item[]{Items.f_42647_, Items.f_42700_, Items.f_42753_, Items.f_42794_, Items.f_42796_, Items.f_42795_, Items.f_42797_, Items.f_42798_}).m_126580_(TinkerTags.Items.SLIMY_PLANKS);
        this.m_126548_((Tag.Named)TinkerTags.Items.VARIANT_LOGS).addTags(new Tag.Named[]{ItemTags.f_13184_, ItemTags.f_13188_, ItemTags.f_13185_, ItemTags.f_13187_, ItemTags.f_13183_, ItemTags.f_13186_, ItemTags.f_13189_, ItemTags.f_13190_, TinkerTags.Items.SLIMY_LOGS});
        this.m_126548_((Tag.Named)TinkerTags.Items.DEFAULT_PATTERNS).m_126582_((Object)((Item)TinkerTables.pattern.get()));
        this.m_126548_((Tag.Named)TinkerTags.Items.REUSABLE_PATTERNS).m_126580_(TinkerTags.Items.GOLD_CASTS);
        this.m_126548_((Tag.Named)TinkerTags.Items.PATTERNS).addTags(new Tag.Named[]{TinkerTags.Items.DEFAULT_PATTERNS, TinkerTags.Items.REUSABLE_PATTERNS});
    }

    private void addSmeltery() {
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SEARED_BRICKS, (Tag.Named)TinkerTags.Items.SEARED_BRICKS);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SEARED_BLOCKS, (Tag.Named)TinkerTags.Items.SEARED_BLOCKS);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SCORCHED_BLOCKS, (Tag.Named)TinkerTags.Items.SCORCHED_BLOCKS);
        this.m_126533_(BlockTags.f_13085_, ItemTags.f_13154_);
        this.m_126548_((Tag.Named)TinkerTags.Items.SMELTERY).m_126580_(TinkerTags.Items.SEARED_BLOCKS).m_126580_(TinkerTags.Items.SEARED_TANKS).m_126584_((Object[])new Item[]{TinkerSmeltery.smelteryController.m_5456_(), TinkerSmeltery.searedDrain.m_5456_(), TinkerSmeltery.searedChute.m_5456_(), TinkerSmeltery.searedDuct.m_5456_(), TinkerSmeltery.searedGlass.m_5456_(), TinkerSmeltery.searedLadder.m_5456_()});
        this.m_126548_((Tag.Named)TinkerTags.Items.FOUNDRY).m_126580_(TinkerTags.Items.SCORCHED_BLOCKS).m_126580_(TinkerTags.Items.SCORCHED_TANKS).m_126584_((Object[])new Item[]{TinkerSmeltery.foundryController.m_5456_(), TinkerSmeltery.scorchedDrain.m_5456_(), TinkerSmeltery.scorchedChute.m_5456_(), TinkerSmeltery.scorchedDuct.m_5456_(), TinkerSmeltery.scorchedGlass.m_5456_(), TinkerSmeltery.scorchedLadder.m_5456_()});
        this.m_126548_((Tag.Named)TinkerTags.Items.GENERAL_STRUCTURE_DEBUG);
        this.m_126548_((Tag.Named)TinkerTags.Items.SMELTERY_DEBUG).m_126580_(TinkerTags.Items.GENERAL_STRUCTURE_DEBUG).m_126580_(TinkerTags.Items.SMELTERY);
        this.m_126548_((Tag.Named)TinkerTags.Items.FOUNDRY_DEBUG).m_126580_(TinkerTags.Items.GENERAL_STRUCTURE_DEBUG).m_126580_(TinkerTags.Items.FOUNDRY);
        TagsProvider.TagAppender goldCasts = this.m_126548_((Tag.Named)TinkerTags.Items.GOLD_CASTS);
        TagsProvider.TagAppender sandCasts = this.m_126548_((Tag.Named)TinkerTags.Items.SAND_CASTS);
        TagsProvider.TagAppender redSandCasts = this.m_126548_((Tag.Named)TinkerTags.Items.RED_SAND_CASTS);
        TagsProvider.TagAppender singleUseCasts = this.m_126548_((Tag.Named)TinkerTags.Items.SINGLE_USE_CASTS);
        TagsProvider.TagAppender multiUseCasts = this.m_126548_((Tag.Named)TinkerTags.Items.MULTI_USE_CASTS);
        Consumer<CastItemObject> addCast = cast -> {
            goldCasts.m_126582_((Object)((Item)cast.get()));
            sandCasts.m_126582_((Object)cast.getSand());
            redSandCasts.m_126582_((Object)cast.getRedSand());
            singleUseCasts.m_126580_(cast.getSingleUseTag());
            this.m_126548_((Tag.Named)cast.getSingleUseTag()).m_126584_((Object[])new Item[]{cast.getSand(), cast.getRedSand()});
            multiUseCasts.m_126580_(cast.getMultiUseTag());
            this.m_126548_((Tag.Named)cast.getMultiUseTag()).m_126582_((Object)((Item)cast.get()));
        };
        sandCasts.m_126582_((Object)((Item)TinkerSmeltery.blankSandCast.get()));
        redSandCasts.m_126582_((Object)((Item)TinkerSmeltery.blankRedSandCast.get()));
        singleUseCasts.m_126580_(TinkerTags.Items.BLANK_SINGLE_USE_CASTS);
        this.m_126548_((Tag.Named)TinkerTags.Items.BLANK_SINGLE_USE_CASTS).m_126584_((Object[])new Item[]{(Item)TinkerSmeltery.blankSandCast.get(), (Item)TinkerSmeltery.blankRedSandCast.get()});
        addCast.accept(TinkerSmeltery.ingotCast);
        addCast.accept(TinkerSmeltery.nuggetCast);
        addCast.accept(TinkerSmeltery.gemCast);
        addCast.accept(TinkerSmeltery.rodCast);
        addCast.accept(TinkerSmeltery.repairKitCast);
        addCast.accept(TinkerSmeltery.plateCast);
        addCast.accept(TinkerSmeltery.gearCast);
        addCast.accept(TinkerSmeltery.coinCast);
        addCast.accept(TinkerSmeltery.wireCast);
        addCast.accept(TinkerSmeltery.pickHeadCast);
        addCast.accept(TinkerSmeltery.smallAxeHeadCast);
        addCast.accept(TinkerSmeltery.smallBladeCast);
        addCast.accept(TinkerSmeltery.hammerHeadCast);
        addCast.accept(TinkerSmeltery.broadAxeHeadCast);
        addCast.accept(TinkerSmeltery.broadBladeCast);
        addCast.accept(TinkerSmeltery.toolBindingCast);
        addCast.accept(TinkerSmeltery.roundPlateCast);
        addCast.accept(TinkerSmeltery.largePlateCast);
        addCast.accept(TinkerSmeltery.toolHandleCast);
        addCast.accept(TinkerSmeltery.toughHandleCast);
        this.m_126548_((Tag.Named)TinkerTags.Items.CASTS).m_126580_(TinkerTags.Items.GOLD_CASTS).m_126580_(TinkerTags.Items.SAND_CASTS).m_126580_(TinkerTags.Items.RED_SAND_CASTS);
        this.m_126548_((Tag.Named)TinkerTags.Items.TABLE_EMPTY_CASTS).m_126582_((Object)TinkerCommons.goldBars.m_5456_());
        this.m_126548_((Tag.Named)TinkerTags.Items.BASIN_EMPTY_CASTS).m_126582_((Object)TinkerCommons.goldPlatform.m_5456_());
        this.m_126548_((Tag.Named)TinkerTags.Items.DUCT_CONTAINERS).m_126584_((Object[])new Item[]{Items.f_42446_, (Item)TinkerSmeltery.copperCan.get(), TinkerSmeltery.searedLantern.m_5456_(), TinkerSmeltery.scorchedLantern.m_5456_()});
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SEARED_TANKS, (Tag.Named)TinkerTags.Items.SEARED_TANKS);
        this.m_126533_((Tag.Named)TinkerTags.Blocks.SCORCHED_TANKS, (Tag.Named)TinkerTags.Items.SCORCHED_TANKS);
        this.m_126548_((Tag.Named)TinkerTags.Items.TANKS).m_126580_(TinkerTags.Items.SEARED_TANKS).m_126580_(TinkerTags.Items.SCORCHED_TANKS);
    }

    public String m_6055_() {
        return "Tinkers Construct Item Tags";
    }

    private void addMetalTags(MetalItemObject metal) {
        this.m_126548_((Tag.Named)metal.getIngotTag()).m_126582_((Object)metal.getIngot());
        this.m_126548_((Tag.Named)Tags.Items.INGOTS).m_126580_((Tag.Named)metal.getIngotTag());
        this.m_126548_((Tag.Named)metal.getNuggetTag()).m_126582_((Object)metal.getNugget());
        this.m_126548_((Tag.Named)Tags.Items.NUGGETS).m_126580_((Tag.Named)metal.getNuggetTag());
        this.m_126533_((Tag.Named)metal.getBlockTag(), (Tag.Named)metal.getBlockItemTag());
    }

    @SafeVarargs
    private void addToolTags(ItemLike tool, Tag.Named<Item> ... tags) {
        Item item = tool.m_5456_();
        for (Tag.Named<Item> tag : tags) {
            this.m_126548_(tag).m_126582_((Object)item);
        }
    }

    private Tag.Named<Item> getArmorTag(ArmorSlotType slotType) {
        return switch (slotType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorSlotType.BOOTS -> TinkerTags.Items.BOOTS;
            case ArmorSlotType.LEGGINGS -> TinkerTags.Items.LEGGINGS;
            case ArmorSlotType.CHESTPLATE -> TinkerTags.Items.CHESTPLATES;
            case ArmorSlotType.HELMET -> TinkerTags.Items.HELMETS;
        };
    }

    @SafeVarargs
    private void addArmorTags(EnumObject<ArmorSlotType, ? extends Item> armor, Tag.Named<Item> ... tags) {
        armor.forEach((type, item) -> {
            for (Tag.Named tag : tags) {
                this.m_126548_(tag).m_126582_(item);
            }
            this.m_126548_(this.getArmorTag((ArmorSlotType)((Object)type))).m_126582_(item);
        });
    }
}

