/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class RemapHandler {
    private static final Map<String, ResourceLocation> itemReMap = new HashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> fullReMap = new HashMap<String, ResourceLocation>();

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            String k = mapping.key.m_135815_();
            if (fullReMap.containsKey(k)) {
                ResourceLocation i = fullReMap.get(k);
                try {
                    Supplementaries.LOGGER.warn("Remapping block '{}' to '{}'", (Object)mapping.key, (Object)i);
                    mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(i)));
                }
                catch (Throwable t) {
                    Supplementaries.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
                }
                continue;
            }
            if (!k.contains("hanging_sign")) continue;
            try {
                mapping.remap((IForgeRegistryEntry)((Block)ModRegistry.HANGING_SIGNS.get(VanillaWoodTypes.OAK).get()));
            }
            catch (Exception exception) {}
        }
    }

    @SubscribeEvent
    public static void onRemapTiles(RegistryEvent.MissingMappings<BlockEntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            String k = mapping.key.m_135815_();
            if (!fullReMap.containsKey(k)) continue;
            ResourceLocation i = fullReMap.get(k);
            try {
                Supplementaries.LOGGER.warn("Remapping tile entity '{}' to '{}'", (Object)mapping.key, (Object)i);
                mapping.remap((IForgeRegistryEntry)((BlockEntityType)ForgeRegistries.BLOCK_ENTITIES.getValue(i)));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping  tile entity '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            String k = mapping.key.m_135815_();
            if (itemReMap.containsKey(k)) {
                ResourceLocation i = itemReMap.get(k);
                try {
                    Supplementaries.LOGGER.warn("Remapping item '{}' to '{}'", (Object)mapping.key, (Object)i);
                    mapping.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(i)));
                }
                catch (Throwable t) {
                    Supplementaries.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
                }
                continue;
            }
            if (k.contains("hanging_sign")) {
                try {
                    mapping.remap((IForgeRegistryEntry)((Item)ModRegistry.HANGING_SIGNS_ITEMS.get(VanillaWoodTypes.OAK).get()));
                }
                catch (Exception exception) {}
                continue;
            }
            if (!k.contains("sign_post")) continue;
            try {
                mapping.remap((IForgeRegistryEntry)((Item)ModRegistry.SIGN_POST_ITEMS.get(VanillaWoodTypes.OAK).get()));
            }
            catch (Exception exception) {}
        }
    }

    @SubscribeEvent
    public static void onRemapEntityTypes(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            if (!fullReMap.containsKey(mapping.key.m_135815_())) continue;
            try {
                Supplementaries.LOGGER.warn("Remapping entity '{}' to '{}'", (Object)mapping.key, (Object)fullReMap.get(mapping.key.m_135815_()));
                mapping.remap((IForgeRegistryEntry)((EntityType)ForgeRegistries.ENTITIES.getValue(fullReMap.get(mapping.key.m_135815_()))));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping entity '{}' to '{}' failed: {}", (Object)mapping.key, (Object)fullReMap.get(mapping.key.m_135815_()), (Object)t);
            }
        }
    }

    static {
        fullReMap.put("orange_trader", ModRegistry.RED_MERCHANT.getId());
        fullReMap.put("piston_launcher", ModRegistry.SPRING_LAUNCHER.getId());
        fullReMap.put("piston_launcher_arm", ModRegistry.SPRING_LAUNCHER_ARM.getId());
        fullReMap.put("piston_launcher_head", ModRegistry.SPRING_LAUNCHER_HEAD.getId());
        itemReMap.put("jar_full", ModRegistry.JAR_ITEM.getId());
        itemReMap.put("jar_full_tinted", ModRegistry.JAR_ITEM_TINTED.getId());
        itemReMap.put("cage_full", ModRegistry.CAGE_ITEM.getId());
        itemReMap.put("wall_lantern", Items.f_42778_.getRegistryName());
        itemReMap.put("stick", Items.f_42398_.getRegistryName());
        itemReMap.put("blaze_rod", Items.f_42585_.getRegistryName());
        itemReMap.put("hanging_flower_pot", Items.f_42618_.getRegistryName());
        itemReMap.put("gunpowder", Items.f_42403_.getRegistryName());
        for (RegistryObject<Block> banner : ModRegistry.CEILING_BANNERS.values()) {
            itemReMap.put(banner.getId().m_135815_(), new ResourceLocation("minecraft", banner.getId().m_135815_().replace("ceiling_banner_", "") + "_banner"));
        }
        itemReMap.put("directional_cake", Items.f_42502_.getRegistryName());
        itemReMap.putAll(fullReMap);
    }
}

