/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CeilingBannerBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.VerticalSlabBlock;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.items.BurnableBlockItem;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

public class RegistryHelper {
    public static CreativeModeTab getTab(CreativeModeTab g, String regName) {
        if (RegistryConfigs.reg.isEnabled(regName)) {
            return ModRegistry.MOD_TAB == null ? g : ModRegistry.MOD_TAB;
        }
        return null;
    }

    public static CreativeModeTab getTab(String modId, CreativeModeTab g, String regName) {
        return ModList.get().isLoaded(modId) ? RegistryHelper.getTab(g, regName) : null;
    }

    public static RegistryObject<Item> regItem(String name, Supplier<? extends Item> sup) {
        return ModRegistry.ITEMS.register(name, sup);
    }

    public static RegistryObject<Item> regBlockItem(RegistryObject<Block> blockSup, CreativeModeTab group) {
        return RegistryHelper.regItem(blockSup.getId().m_135815_(), () -> new BlockItem((Block)blockSup.get(), new Item.Properties().m_41491_(group)));
    }

    public static RegistryObject<Item> regBlockItem(RegistryObject<Block> blockSup, CreativeModeTab group, int burnTime) {
        return RegistryHelper.regItem(blockSup.getId().m_135815_(), () -> new BurnableBlockItem((Block)blockSup.get(), new Item.Properties().m_41491_(group), burnTime));
    }

    public static RegistryObject<SimpleParticleType> regParticle(String name) {
        return ModRegistry.PARTICLES.register(name, () -> new SimpleParticleType(true));
    }

    public static RegistryObject<SoundEvent> makeSoundEvent(String name) {
        return ModRegistry.SOUNDS.register(name, () -> new SoundEvent(Supplementaries.res(name)));
    }

    public static boolean doesntHaveWoodInstalled(IWoodType wood) {
        return !ModList.get().isLoaded(wood.getNamespace());
    }

    public static boolean conditionalSigns() {
        return true;
    }

    public static Map<IWoodType, RegistryObject<Block>> makeHangingSingsBlocks() {
        HashMap<IWoodType, RegistryObject<Block>> map = new HashMap<IWoodType, RegistryObject<Block>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            if (RegistryHelper.conditionalSigns() && !wood.isModActive()) continue;
            String name = wood.getHangingSignName();
            map.put(wood, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new HangingSignBlock(BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getColor()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60910_(), wood)));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Item>> makeHangingSignsItems() {
        HashMap<IWoodType, RegistryObject<Item>> map = new HashMap<IWoodType, RegistryObject<Item>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            if (RegistryHelper.conditionalSigns() && !wood.isModActive()) continue;
            String name = wood.getHangingSignName();
            map.put(wood, (RegistryObject<Item>)ModRegistry.ITEMS.register(name, () -> new BurnableBlockItem((Block)ModRegistry.HANGING_SIGNS.get(wood).get(), new Item.Properties().m_41491_(RegistryHelper.doesntHaveWoodInstalled(wood) ? null : RegistryHelper.getTab(CreativeModeTab.f_40750_, "hanging_sign")), wood.canBurn() ? 200 : 0)));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Item>> makeSignPostItems() {
        HashMap<IWoodType, RegistryObject<Item>> map = new HashMap<IWoodType, RegistryObject<Item>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            if (RegistryHelper.conditionalSigns() && !wood.isModActive()) continue;
            String name = wood.getSignPostName();
            map.put(wood, (RegistryObject<Item>)ModRegistry.ITEMS.register(name, () -> new SignPostItem(new Item.Properties().m_41491_(RegistryHelper.doesntHaveWoodInstalled(wood) ? null : RegistryHelper.getTab(CreativeModeTab.f_40750_, "sign_post")), wood)));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Block>> makeFlagBlocks(String baseName) {
        HashMap<DyeColor, RegistryObject<Block>> map = new HashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new FlagBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56736_))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makeFlagItems(String baseName) {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, (RegistryObject<Item>)ModRegistry.ITEMS.register(name, () -> new FlagItem((Block)ModRegistry.FLAGS.get(color).get(), new Item.Properties().m_41487_(16).m_41491_(RegistryHelper.getTab(CreativeModeTab.f_40750_, "flag")))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Block>> makeCeilingBanners(String baseName) {
        HashMap<DyeColor, RegistryObject<Block>> map = new HashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new CeilingBannerBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60910_().m_60918_(SoundType.f_56736_).lootFrom(() -> BannerBlock.m_49014_((DyeColor)color)))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makeCeilingBannersItems() {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (DyeColor color : DyeColor.values()) {
            map.put(color, RegistryHelper.regBlockItem(ModRegistry.CEILING_BANNERS.get(color), null));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Block>> makePresents(String baseName) {
        HashMap<DyeColor, RegistryObject<Block>> map = new HashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new PresentBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60918_(SoundType.f_56745_))));
        }
        map.put(null, ModRegistry.BLOCKS.register(baseName, () -> new PresentBlock(null, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76411_).m_60978_(1.0f).m_60918_(SoundType.f_56745_))));
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makePresentsItems() {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (DyeColor color : DyeColor.values()) {
            RegistryObject<Block> p = ModRegistry.PRESENTS.get(color);
            map.put(color, (RegistryObject<Item>)ModRegistry.ITEMS.register(p.getId().m_135815_(), () -> new PresentItem((Block)p.get(), new Item.Properties().m_41491_(RegistryHelper.getTab(CreativeModeTab.f_40750_, "present")))));
        }
        RegistryObject<Block> p = ModRegistry.PRESENTS.get(null);
        map.put(null, ModRegistry.ITEMS.register(p.getId().m_135815_(), () -> new PresentItem((Block)p.get(), new Item.Properties().m_41491_(RegistryHelper.getTab(CreativeModeTab.f_40750_, "present")))));
        return map;
    }

    public static EnumMap<VariantType, RegistryObject<Block>> registerFullBlockSet(String baseName, Block parentBlock) {
        EnumMap<VariantType, RegistryObject<Block>> map = new EnumMap<VariantType, RegistryObject<Block>>(VariantType.class);
        for (VariantType type : VariantType.values()) {
            Object name = baseName;
            if (!type.equals((Object)VariantType.BLOCK)) {
                name = (String)name + "_" + type.name().toLowerCase(Locale.ROOT);
            }
            RegistryObject block2 = ModRegistry.BLOCKS.register((String)name, () -> type.create(parentBlock));
            CreativeModeTab tab = switch (type) {
                case VariantType.VERTICAL_SLAB -> RegistryHelper.getTab("quark", CreativeModeTab.f_40749_, baseName);
                case VariantType.WALL -> RegistryHelper.getTab(CreativeModeTab.f_40750_, baseName);
                default -> RegistryHelper.getTab(CreativeModeTab.f_40749_, baseName);
            };
            RegistryHelper.regBlockItem((RegistryObject<Block>)block2, tab);
            map.put(type, (RegistryObject<Block>)block2);
        }
        return map;
    }

    public static enum VariantType {
        BLOCK(Block::new),
        SLAB(SlabBlock::new),
        VERTICAL_SLAB(VerticalSlabBlock::new),
        WALL(WallBlock::new),
        STAIRS(StairBlock::new);

        private final BiFunction<Supplier<BlockState>, BlockBehaviour.Properties, Block> constructor;

        private VariantType(BiFunction<Supplier<BlockState>, BlockBehaviour.Properties, Block> constructor) {
            this.constructor = constructor;
        }

        private VariantType(Function<BlockBehaviour.Properties, Block> constructor) {
            this.constructor = (b, p) -> (Block)constructor.apply((BlockBehaviour.Properties)p);
        }

        private Block create(Block parent) {
            return this.constructor.apply(() -> ((Block)parent).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent));
        }
    }
}

