/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.songs;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSongsPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.world.songs.FluteSongsReloadListener;
import net.mehvahdjukaar.supplementaries.common.world.songs.Song;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class SongsManager {
    private static final Map<ResourceLocation, Song> SONGS = new LinkedHashMap<ResourceLocation, Song>();
    private static final List<WeightedEntry.Wrapper<ResourceLocation>> SONG_WEIGHTED_LIST = new ArrayList<WeightedEntry.Wrapper<ResourceLocation>>();
    private static final Map<UUID, Song> CURRENTLY_PAYING = new HashMap<UUID, Song>();
    private static final Map<Long, List<Integer>> RECORDING = new HashMap<Long, List<Integer>>();
    private static boolean IS_RECORDING = false;
    private static final List<NoteBlockInstrument> WHITELIST = new ArrayList<NoteBlockInstrument>();

    public static void addSong(ResourceLocation res, Song song) {
        SONGS.put(res, song);
        SONG_WEIGHTED_LIST.add((WeightedEntry.Wrapper<ResourceLocation>)WeightedEntry.m_146290_((Object)res, (int)song.getWeight()));
    }

    public static void clearSongs() {
        SONGS.clear();
        SONG_WEIGHTED_LIST.clear();
    }

    public static void sendSongsToClient() {
        NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientBoundSyncSongsPacket(SONGS));
    }

    public static Song setCurrentlyPlaying(UUID id, ResourceLocation songKey) {
        Song song = SONGS.getOrDefault(songKey, Song.EMPTY);
        CURRENTLY_PAYING.put(id, song);
        return song;
    }

    public static void clearCurrentlyPlaying(UUID id) {
        CURRENTLY_PAYING.remove(id);
    }

    @Nonnull
    private static ResourceLocation selectRandomSong(Random random) {
        Optional song = WeightedRandom.m_146317_((Random)random, SONG_WEIGHTED_LIST);
        return song.map(WeightedEntry.Wrapper::m_146310_).orElseGet(() -> new ResourceLocation(""));
    }

    public static void playRandomSong(ItemStack stack, InstrumentItem instrument, LivingEntity entity2, long timeSinceStarted) {
        Song song;
        UUID id = entity2.m_142081_();
        if (!CURRENTLY_PAYING.containsKey(id)) {
            ResourceLocation res = null;
            if (stack.m_41788_()) {
                String name = stack.m_41786_().getString().toLowerCase(Locale.ROOT).replace(" ", "_");
                for (ResourceLocation v : SONGS.keySet()) {
                    if (!v.m_135815_().equals(name)) continue;
                    res = v;
                    break;
                }
            }
            if (res == null) {
                res = SongsManager.selectRandomSong(entity2.f_19853_.f_46441_);
            }
            song = SongsManager.setCurrentlyPlaying(id, res);
        } else {
            song = CURRENTLY_PAYING.get(id);
        }
        SongsManager.playSong(instrument, entity2, song, timeSinceStarted);
    }

    public static boolean playSong(InstrumentItem instrumentItem, LivingEntity entity2, ResourceLocation sandstorm, long timeSinceStarted) {
        return SongsManager.playSong(instrumentItem, entity2, SONGS.getOrDefault(sandstorm, Song.EMPTY), timeSinceStarted);
    }

    public static boolean playSong(InstrumentItem instrument, LivingEntity entity2, Song song, long timeSinceStarted) {
        IntList notes;
        boolean played = false;
        if (timeSinceStarted % (long)song.getTempo() == 0L && (notes = song.getNoteToPlay(timeSinceStarted)).size() > 0 && notes.getInt(0) > 0) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity2), (Object)new ClientBoundPlaySongNotesPacket(notes, entity2));
            played = true;
        }
        return played;
    }

    public static void startRecording(NoteBlockInstrument[] whitelist) {
        RECORDING.clear();
        IS_RECORDING = true;
        WHITELIST.clear();
        WHITELIST.addAll(List.of(whitelist));
    }

    public static String stopRecording(Level level, String name, int speedup) {
        int n;
        IS_RECORDING = false;
        long start = Long.MAX_VALUE;
        for (Long l : RECORDING.keySet()) {
            start = Math.min(start, l);
        }
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (Map.Entry<Long, List<Integer>> entry : RECORDING.entrySet()) {
            int notes = 0;
            List<Integer> noteList = entry.getValue();
            for (int i = 0; i < Math.min(4, noteList.size()); ++i) {
                notes = (int)((double)notes + (double)noteList.get(i).intValue() * Math.pow(100.0, i));
            }
            treeMap.put((int)(entry.getKey() - start), notes);
        }
        boolean bl = true;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int lastTime = 0;
        Iterator i = treeMap.keySet().iterator();
        while (i.hasNext()) {
            int key = (Integer)i.next();
            int note = (Integer)treeMap.get(key);
            int interval = -(key - lastTime);
            lastTime = key;
            if (interval != 0) {
                hashSet.add(-interval);
                if (-interval > n) {
                    n = -interval;
                }
                arrayList.add(interval);
            }
            arrayList.add(note);
        }
        int GCD = 1;
        void div = n;
        while (div > 0) {
            void d = div--;
            boolean match = hashSet.stream().allMatch(arg_0 -> SongsManager.lambda$stopRecording$2((int)d, arg_0));
            if (!match) continue;
            GCD = Math.abs((int)div);
            break;
        }
        ArrayList<Integer> finalNotes = new ArrayList<Integer>();
        Iterator d = arrayList.iterator();
        while (d.hasNext()) {
            int i2 = (Integer)d.next();
            if (i2 < 0) {
                finalNotes.add(i2 / GCD);
                continue;
            }
            finalNotes.add(i2);
        }
        if (((String)name).isEmpty()) {
            name = "recorded-" + start;
        }
        Song song = new Song((String)name, GCD, finalNotes.toArray(new Integer[0]), "recorded in-game");
        FluteSongsReloadListener.saveRecordedSong(song);
        SONGS.clear();
        song.processForPlaying();
        SONGS.put(Supplementaries.res((String)name), song);
        if (!level.f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientBoundSyncSongsPacket(SONGS));
        }
        RECORDING.clear();
        return song.getTranslationKey();
    }

    public static void recordNote(LevelAccessor levelAccessor, BlockPos pos) {
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (IS_RECORDING) {
                BlockState state = level.m_8055_(pos);
                SongsManager.recordNote(level, (Integer)state.m_61143_((Property)NoteBlock.f_55013_) + 1, (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_));
            }
        }
    }

    public static void recordNote(Level level, int note, NoteBlockInstrument instrument) {
        if (WHITELIST.size() == 0 || WHITELIST.contains(instrument)) {
            List notes = RECORDING.computeIfAbsent(level.m_46467_(), t -> new ArrayList());
            notes.add(note);
        }
    }
}

