/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.generation.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class StructureLocator {
    private static final List<StructureFeature<?>> TARGETS = new ArrayList();

    public static void init() {
        for (String name : (List)ServerConfigs.spawn.SIGNS_VILLAGES.get()) {
            ResourceLocation res = new ResourceLocation(name);
            if (!ForgeRegistries.STRUCTURE_FEATURES.containsKey(res)) continue;
            TARGETS.add((StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(res));
        }
    }

    private static int dist(BlockPos pos1, BlockPos pos2) {
        int i = pos2.m_123341_() - pos1.m_123341_();
        int j = pos2.m_123343_() - pos1.m_123343_();
        return (int)Mth.m_14116_((float)(i * i + j * j));
    }

    public static Pair<List<Pair<Integer, BlockPos>>, Boolean> find(ServerLevel world, int posX, int posZ, int count) {
        ArrayList<ImmutablePair> found = new ArrayList<ImmutablePair>();
        boolean inVillage = false;
        if (world.m_142572_().m_129910_().m_5961_().m_64657_()) {
            ChunkGenerator gen = world.m_7726_().m_8481_();
            BiomeSource biomeSource = gen.m_62218_();
            ArrayList possibleTargets = new ArrayList();
            ArrayList<StructureFeatureConfiguration> sepSettings = new ArrayList<StructureFeatureConfiguration>();
            for (StructureFeature<?> str : TARGETS) {
                StructureFeatureConfiguration sep = gen.m_62205_().m_64593_(str);
                if (sep == null) continue;
                possibleTargets.add(str);
                sepSettings.add(sep);
            }
            long seed = world.m_7328_();
            StructureFeatureManager manager = world.m_8595_();
            int chunkX = posX >> 4;
            int chunkY = posZ >> 4;
            int range = 25;
            for (int r = 0; r <= range; ++r) {
                block2: for (int ind = 0; ind < possibleTargets.size(); ++ind) {
                    for (int x = -r; x <= r; ++x) {
                        boolean edgeX = x == -r || x == r;
                        for (int y = -r; y <= r; ++y) {
                            ChunkAccess ichunk;
                            StructureStart structureStart;
                            int l1;
                            int spacing;
                            int k1;
                            boolean edgeY;
                            boolean bl = edgeY = y == -r || y == r;
                            if (!edgeX && !edgeY) continue;
                            StructureFeatureConfiguration settings = (StructureFeatureConfiguration)sepSettings.get(ind);
                            StructureFeature structure = (StructureFeature)possibleTargets.get(ind);
                            ChunkPos chunkpos = structure.m_191122_(settings, seed, k1 = chunkX + (spacing = settings.m_68171_()) * x, l1 = chunkY + spacing * y);
                            StructureCheckResult structurecheckresult = manager.m_196670_(chunkpos, structure, false);
                            if (structurecheckresult != StructureCheckResult.START_NOT_PRESENT && (structureStart = manager.m_47297_(SectionPos.m_175562_((ChunkAccess)(ichunk = world.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_))), structure, (FeatureAccess)ichunk)) != null && structureStart.m_73603_()) {
                                BlockPos p = structure.m_183220_(structureStart.m_163625_());
                                int distance = StructureLocator.dist(new BlockPos(posX, 0, posZ), p);
                                if (distance > 90) {
                                    found.add(new ImmutablePair((Object)distance, (Object)p));
                                } else {
                                    inVillage = true;
                                }
                            }
                            if (r == 0 || r > 5 && found.size() >= count) break;
                        }
                        if (r == 0 || r > 8 && found.size() >= count) continue block2;
                    }
                }
                if (found.size() >= count) break;
            }
        }
        Collections.sort(found);
        return new ImmutablePair(found, (Object)inVillage);
    }
}

