/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import java.util.Calendar;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.tetra.TetraToolHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;

public class CommonUtil {
    public static DamageSource SPIKE_DAMAGE = new DamageSource("supplementaries.bamboo_spikes");
    public static DamageSource BOTTLING_DAMAGE = new DamageSource("supplementaries.xp_extracting");
    public static DamageSource AMETHYST_SHARD_DAMAGE = new DamageSource("supplementaries.amethyst_shard");
    public static Festivity FESTIVITY = Festivity.get();
    public static final AABB FENCE_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0).m_83215_();
    public static final AABB POST_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0).m_83215_();
    public static final AABB WALL_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)12.0).m_83215_();
    private static final ShulkerBoxBlockEntity SHULKER_TILE = new ShulkerBoxBlockEntity(BlockPos.f_121853_, Blocks.f_50456_.m_49966_());

    public static boolean isSword(Item i) {
        if (CompatHandler.tetra && TetraToolHelper.isTetraSword(i)) {
            return true;
        }
        return i instanceof SwordItem;
    }

    public static boolean isTool(Item i) {
        if (CompatHandler.tetra && TetraToolHelper.isTetraTool(i)) {
            return true;
        }
        return i instanceof DiggerItem || i instanceof TridentItem;
    }

    public static boolean isLantern(Item i) {
        if (i instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)i;
            Block b = blockItem.m_40614_();
            String namespace = b.getRegistryName().m_135827_();
            if (namespace.equals("skinnedlanterns")) {
                return true;
            }
            if (b instanceof LanternBlock && !ServerConfigs.cached.WALL_LANTERN_BLACKLIST.contains(namespace)) {
                return !b.m_49966_().m_155947_();
            }
        }
        return false;
    }

    public static boolean isCookie(Item i) {
        return ModTags.COOKIES.m_8110_((Object)i);
    }

    public static boolean isBrick(Item i) {
        return ModTags.BRICKS.m_8110_((Object)i);
    }

    public static boolean isCake(Item i) {
        return i == Items.f_42502_;
    }

    public static boolean isPot(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).m_40614_();
            return b instanceof FlowerPotBlock;
        }
        return false;
    }

    public static AABB getDirectionBB(BlockPos pos, Direction facing, int offset) {
        BlockPos endPos = pos.m_5484_(facing, offset);
        switch (facing) {
            case NORTH: {
                endPos = endPos.m_142082_(1, 1, 0);
                break;
            }
            case SOUTH: {
                endPos = endPos.m_142082_(1, 1, 1);
                pos = pos.m_142082_(0, 0, 1);
                break;
            }
            case UP: {
                endPos = endPos.m_142082_(1, 1, 1);
                pos = pos.m_142082_(0, 1, 0);
                break;
            }
            case EAST: {
                endPos = endPos.m_142082_(1, 1, 1);
                pos = pos.m_142082_(1, 0, 0);
                break;
            }
            case WEST: {
                endPos = endPos.m_142082_(0, 1, 1);
                break;
            }
            case DOWN: {
                endPos = endPos.m_142082_(1, 0, 1);
            }
        }
        return new AABB(pos, endPos);
    }

    public static boolean isShapeEqual(AABB s1, AABB s2) {
        return s1.f_82288_ == s2.f_82288_ && s1.f_82289_ == s2.f_82289_ && s1.f_82290_ == s2.f_82290_ && s1.f_82291_ == s2.f_82291_ && s1.f_82292_ == s2.f_82292_ && s1.f_82293_ == s2.f_82293_;
    }

    public static int getPostSize(BlockState state, BlockPos pos, LevelReader world) {
        Block block2 = state.m_60734_();
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        if (shape != Shapes.m_83040_()) {
            AABB s = shape.m_83215_();
            if (block2 instanceof FenceBlock || block2 instanceof SignPostBlock || state.m_60620_((Tag)Tags.Blocks.FENCES) || CommonUtil.isShapeEqual(FENCE_SHAPE, s)) {
                return 1;
            }
            if (block2 instanceof WallBlock || state.m_60620_((Tag)BlockTags.f_13032_) || CommonUtil.isShapeEqual(WALL_SHAPE, s)) {
                return 2;
            }
            if (CommonUtil.isShapeEqual(POST_SHAPE, s)) {
                return 1;
            }
        }
        return 0;
    }

    public static boolean isVertical(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            return state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y;
        }
        return true;
    }

    public static boolean isPost(BlockState state) {
        return CommonUtil.isVertical(state) && state.m_60620_(ModTags.POSTS);
    }

    public static boolean isAllowedInShulker(ItemStack stack) {
        return SHULKER_TILE.m_7155_(0, stack, null);
    }

    public static boolean withinDistanceDown(BlockPos pos, Vec3 vector, double distW, double distDown) {
        double dx = vector.m_7096_() - ((double)pos.m_123341_() + 0.5);
        double dy = vector.m_7098_() - ((double)pos.m_123342_() + 0.5);
        double dz = vector.m_7094_() - ((double)pos.m_123343_() + 0.5);
        double mydistW = dx * dx + dz * dz;
        return mydistW < distW * distW && dy < distW && dy > -distDown;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static HitResult rayTrace(LivingEntity entity2, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return CommonUtil.rayTrace((Entity)entity2, world, blockMode, fluidMode, entity2.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_());
    }

    public static HitResult rayTrace(Entity entity2, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity2.m_146892_();
        Vec3 ray = entity2.m_20252_(1.0f).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity2);
        return world.m_45547_(context);
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public int getCandyWrappingIndex() {
            return switch (this) {
                default -> 0;
                case HALLOWEEN -> 1;
                case CHRISTMAS -> 2;
            };
        }

        private static Festivity get() {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date <= 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 23 && date <= 27) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

