/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BlockItemUtils {
    @Nullable
    public static BlockState getPlacementState(BlockPlaceContext context, Block block2) {
        BlockState blockstate = block2.m_5573_(context);
        return blockstate != null && BlockItemUtils.canPlace(context, blockstate) ? blockstate : null;
    }

    public static boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collisionContext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(state, context.m_8083_(), collisionContext);
    }

    private static BlockState updateBlockStateFromTag(BlockPos pos, Level world, ItemStack stack, BlockState state) {
        BlockState blockstate = state;
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            CompoundTag blockStateTag = tag.m_128469_("BlockStateTag");
            StateDefinition stateDefinition = state.m_60734_().m_49965_();
            for (String s : blockStateTag.m_128431_()) {
                Property property = stateDefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = blockStateTag.m_128423_(s).m_7916_();
                blockstate = BlockItemUtils.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != state) {
            world.m_7731_(pos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> tProperty, String name) {
        return tProperty.m_6215_(name).map(p -> (BlockState)state.m_61124_(tProperty, p)).orElse(state);
    }

    private static SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity2) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity2).m_56777_();
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace) {
        if (!context.m_7059_() || context == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = BlockItemUtils.getPlacementState(context, blockToPlace);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!context.m_43725_().m_7731_(context.m_8083_(), blockstate, 11)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        BlockState placedState = world.m_8055_(blockpos);
        Block block2 = placedState.m_60734_();
        if (block2 == blockstate.m_60734_()) {
            placedState = BlockItemUtils.updateBlockStateFromTag(blockpos, world, itemstack, placedState);
            BlockItem.m_40582_((Level)world, (Player)player, (BlockPos)blockpos, (ItemStack)itemstack);
            block2.m_6402_(world, blockpos, placedState, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_59469_(serverPlayer, blockpos, itemstack);
            }
            world.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
        }
        SoundType soundtype = placedState.getSoundType((LevelReader)world, blockpos, (Entity)context.m_43723_());
        world.m_5594_(player, blockpos, BlockItemUtils.getPlaceSound(placedState, world, blockpos, context.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }
}

