/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.pickle.PicklePlayer;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PicklePacket {
    private UUID playerID;
    private final boolean on;

    public PicklePacket(UUID appliesTo, boolean on) {
        this.playerID = appliesTo;
        this.on = on;
    }

    public static void buffer(PicklePacket pkt, FriendlyByteBuf buf) {
        buf.writeBoolean(pkt.on);
        if (pkt.playerID != null) {
            buf.m_130077_(pkt.playerID);
        }
    }

    public PicklePacket(FriendlyByteBuf buf) {
        this.on = buf.readBoolean();
        if (buf.isReadable()) {
            this.playerID = buf.m_130259_();
        }
    }

    public static void handler(PicklePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> PicklePlayer.PickleData.set(msg.playerID, msg.on));
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                UUID id = player.m_36316_().getId();
                if (PicklePlayer.PickleData.isDev(id)) {
                    PicklePlayer.PickleData.set(id, msg.on);
                    msg.playerID = id;
                    for (ServerPlayer p : player.m_20194_().m_6846_().m_11314_()) {
                        if (p == player) continue;
                        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)msg);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

