/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.api.ISoapWashable;
import net.mehvahdjukaar.supplementaries.client.particles.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSpawnBlockParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;

public class SoapItem
extends Item {
    public static final FoodProperties SOAP_FOOD = new FoodProperties.Builder().m_38760_(0).m_38758_(0.1f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19614_, 120, 2), 1.0f).m_38767_();

    public SoapItem(Item.Properties pProperties) {
        super(pProperties.m_41489_(SOAP_FOOD));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!SoapItem.hasBeenEatenBefore(player, level)) {
            ItemStack itemstack = player.m_21120_(hand);
            if (player.m_36391_(true)) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasBeenEatenBefore(Player player, Level level) {
        ResourceLocation res = new ResourceLocation("supplementaries", "husbandry/soap");
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Advancement a = serverLevel.m_142572_().m_129889_().m_136041_(res);
                if (a == null) return false;
                return serverPlayer.m_8960_().m_135996_(a).m_8193_();
            }
        }
        if (!(player instanceof LocalPlayer)) return false;
        LocalPlayer localPlayer = (LocalPlayer)player;
        ClientAdvancements advancements = localPlayer.f_108617_.m_105145_();
        Advancement a = advancements.m_104396_().m_139337_(res);
        if (a == null) return false;
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (SoapItem.tryCleaning(context.m_43722_(), level, context.m_8083_(), context.m_43723_())) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(context);
    }

    public static boolean tryCleaning(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        BlockState newState = null;
        BlockState oldState = level.m_8055_(pos);
        Block b = oldState.m_60734_();
        boolean success = false;
        if (b instanceof ISoapWashable) {
            ISoapWashable soapWashable = (ISoapWashable)b;
            success = soapWashable.tryWash(level, pos, oldState);
        } else {
            ItemStack temp = new ItemStack((ItemLike)Items.f_42386_);
            Optional<BlockState> optional = Optional.ofNullable(b.getToolModifiedState(oldState, level, pos, null, temp, ToolActions.AXE_WAX_OFF));
            if (optional.isPresent()) {
                newState = optional.get();
            }
            optional = Optional.ofNullable(b.getToolModifiedState(oldState, level, pos, null, temp, ToolActions.AXE_SCRAPE));
            while (optional.isPresent()) {
                newState = optional.get();
                optional = Optional.ofNullable(b.getToolModifiedState(newState, level, pos, null, temp, ToolActions.AXE_SCRAPE));
            }
            if (newState == null) {
                String[] keywords;
                ResourceLocation r = oldState.m_60734_().getRegistryName();
                String name = r.m_135815_();
                for (String key : keywords = new String[]{"waxed_", "weathered_", "exposed_", "oxidized_"}) {
                    Block bb;
                    if (!name.contains(key) || (bb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(r.m_135827_(), name.replace(key, "")))) == null || bb == Blocks.f_50016_) continue;
                    newState = bb.m_152465_(oldState);
                    break;
                }
            }
            if (newState != null && newState != oldState) {
                success = true;
                if (!level.f_46443_) {
                    level.m_7731_(pos, newState, 11);
                }
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (success) {
                level.m_5594_(null, pos, SoundEvents.f_144178_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
                NetworkHandler.sendToAllInRangeClients(pos, serverLevel, 32.0, new ClientBoundSpawnBlockParticlePacket(pos, ParticleUtil.EventType.BUBBLE_CLEAN));
                stack.m_41774_(1);
                if (player != null) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                } else {
                    level.m_151555_(GameEvent.f_157792_, pos);
                }
            }
        }
        return success;
    }
}

