/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import net.mehvahdjukaar.selene.api.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.selene.api.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.selene.util.TwoHandedAnimation;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SlingshotItem
extends ProjectileWeaponItem
implements Vanishable,
IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity2, int timeLeft) {
        float power;
        Player player;
        ItemStack projectileStack;
        if (entity2 instanceof Player && !(projectileStack = (player = (Player)entity2).m_6298_(stack)).m_41619_() && this.m_6437_().test(projectileStack) && !((double)(power = this.getPowerForTime(stack, timeLeft)) < 0.085)) {
            int maxProjectiles = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) > 0 ? 3 : 1;
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
            for (int p = 0; p < maxProjectiles && this.m_6437_().test(projectileStack); ++p) {
                projectiles.add(projectileStack.m_41777_());
                if (!player.m_150110_().f_35937_) {
                    projectileStack.m_41774_(1);
                    if (projectileStack.m_41619_()) {
                        player.m_150109_().m_36057_(projectileStack);
                    }
                }
                projectileStack = player.m_6298_(stack);
            }
            if (!world.f_46443_) {
                float[] pitches = SlingshotItem.getShotPitches(world.m_5822_());
                int count = projectiles.size();
                float angle = 10.0f;
                for (int j = 0; j < count; ++j) {
                    boolean stasis = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get()), (ItemStack)stack) != 0;
                    InteractionHand hand = player.m_7655_();
                    power = (float)((double)power * ((ServerConfigs.cached.SLINGSHOT_RANGE + (stasis ? 0.5 : 0.0)) * 1.1));
                    SlingshotItem.shootProjectile(world, entity2, hand, stack, (ItemStack)projectiles.get(j), count == 1 ? 1.0f : pitches[j], power, 1.0f, angle * ((float)j - (float)(count - 1) / 2.0f));
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    private static void shootProjectile(Level world, LivingEntity entity2, InteractionHand hand, ItemStack stack, ItemStack projectileStack, float soundPitch, float power, float accuracy, float yaw) {
        SlingshotProjectileEntity projectile = new SlingshotProjectileEntity(entity2, world, projectileStack, stack);
        Vec3 vector3d1 = entity2.m_20289_(1.0f);
        Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), yaw, true);
        Vec3 vector3d = entity2.m_20252_(1.0f);
        Vector3f vector3f = new Vector3f(vector3d);
        vector3f.m_122251_(quaternion);
        projectile.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), power, accuracy);
        stack.m_41622_(1, entity2, p -> p.m_21190_(hand));
        world.m_7967_((Entity)projectile);
        world.m_6263_(null, entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), SoundEvents.f_12553_, SoundSource.PLAYERS, 1.0f, soundPitch * (1.0f / (world.f_46441_.nextFloat() * 0.3f + 0.9f) + power * 0.6f));
    }

    private static float[] getShotPitches(Random random) {
        boolean flag = random.nextBoolean();
        return new float[]{SlingshotItem.getRandomShotPitch(random, flag), 1.0f, SlingshotItem.getRandomShotPitch(random, !flag)};
    }

    private static float getRandomShotPitch(Random random, boolean left) {
        float f = left ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public float getPowerForTime(ItemStack stack, float timeLeft) {
        float useTime = (float)this.m_8105_(stack) - timeLeft;
        float f = useTime / (float)SlingshotItem.getChargeDuration(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public static int getChargeDuration(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        int maxCharge = ServerConfigs.cached.SLINGSHOT_CHARGE;
        return i == 0 ? maxCharge : maxCharge - maxCharge / 4 * i;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.f_44960_, (Object)Enchantments.f_44959_, (Object)Enchantments.f_44955_).contains((Object)enchantment);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        boolean flag = this.m_6437_().test(player.m_6298_(itemstack));
        if (!flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public Predicate<ItemStack> m_6437_() {
        return s -> {
            Item i = s.m_41720_();
            return !(i instanceof DispensibleContainerItem) && i instanceof BlockItem || ItemsOverrideHandler.hasBlockPlacementAssociated(i);
        };
    }

    public int m_6615_() {
        return 10;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity2, HumanoidArm mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.m_21212_() > 0 && entity2.m_21211_().m_41720_() == this) {
            model.f_102812_.f_104204_ = RotHlpr.wrapRad(0.1f + model.f_102808_.f_104204_);
            model.f_102812_.f_104203_ = RotHlpr.wrapRad(-1.5707964f + model.f_102808_.f_104203_);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity2, HumanoidArm mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.m_21212_() > 0 && entity2.m_21211_().m_41720_() == this) {
            model.f_102811_.f_104204_ = RotHlpr.wrapRad(-0.1f + model.f_102808_.f_104204_);
            model.f_102811_.f_104203_ = RotHlpr.wrapRad(-1.5707964f + model.f_102808_.f_104203_);
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(LivingEntity entity2, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity2.m_6117_() && entity2.m_21212_() > 0 && entity2.m_7655_() == hand) {
            float timeLeft = (float)stack.m_41779_() - ((float)entity2.m_21212_() - partialTicks + 1.0f);
            float f12 = this.getPowerForTime(stack, timeLeft);
            if (f12 > 0.1f) {
                float f15 = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
                float f18 = f12 - 0.1f;
                float f20 = f15 * f18;
                matrixStack.m_85837_(0.0, (double)(f20 * 0.004f), 0.0);
            }
            matrixStack.m_85837_(0.0, 0.0, (double)(f12 * 0.04f));
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }

    public static void animateCrossbowCharge(ModelPart offHand, ModelPart mainHand, LivingEntity entity2, boolean right) {
        offHand.f_104203_ = mainHand.f_104203_;
        float f = CrossbowItem.m_40939_((ItemStack)entity2.m_21211_());
        float f1 = Mth.m_14036_((float)entity2.m_21252_(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        offHand.f_104204_ = Mth.m_14179_((float)f2, (float)0.4f, (float)0.85f) * (float)(right ? 1 : -1);
        offHand.f_104203_ = Mth.m_14179_((float)f2, (float)offHand.f_104203_, (float)-1.5707964f);
    }
}

