/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.util.Set;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RakedGravelBlock;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EatFodderGoal;
import net.mehvahdjukaar.supplementaries.common.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.items.CandyItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.mehvahdjukaar.supplementaries.common.world.data.GlobeData;
import net.mehvahdjukaar.supplementaries.common.world.songs.FluteSongsReloadListener;
import net.mehvahdjukaar.supplementaries.common.world.songs.SongsManager;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;

public class ServerEvents {
    private static final boolean FODDER_ENABLED = (Boolean)RegistryConfigs.reg.FODDER_ENABLED.get();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlockHigh(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        if (ServerConfigs.cached.WALL_LANTERN_HIGH_PRIORITY && !(player = event.getPlayer()).m_5833_()) {
            ItemsOverrideHandler.tryHighPriorityClickedBlockOverride(event, event.getItemStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (!player.m_5833_()) {
            ItemStack stack = event.getItemStack();
            ItemsOverrideHandler.tryPerformClickedBlockOverride(event, stack, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player playerIn = event.getPlayer();
        ItemsOverrideHandler.tryPerformClickedItemOverride(event, playerIn.m_21120_(event.getHand()));
    }

    @SubscribeEvent
    public static void onHoeUsed(UseHoeEvent event) {
        BlockState raked;
        UseOnContext context = event.getContext();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (ServerConfigs.cached.RAKED_GRAVEL && world.m_8055_(pos).m_60713_(Blocks.f_49994_) && (raked = ((Block)ModRegistry.RAKED_GRAVEL.get()).m_49966_()).m_60710_((LevelReader)world, pos)) {
            world.m_7731_(pos, RakedGravelBlock.getConnectedState(raked, world, pos, context.m_8125_()), 11);
            world.m_5594_(context.m_43723_(), pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onAttachTileCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        CapabilityHandler.attachCapabilities(event);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            CandyItem.checkSweetTooth(event.player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity2;
        if (FODDER_ENABLED && (entity2 = event.getEntity()) instanceof Animal) {
            Animal animal = (Animal)entity2;
            EntityType type = event.getEntity().m_6095_();
            if (ModTags.EATS_FODDER.m_8110_((Object)type)) {
                animal.f_21345_.m_25352_(3, (Goal)new EatFodderGoal(animal, 1.0, 8, 2, 30));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new ClientBoundSendLoginPacket(UsernameCache.getMap()));
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.warn("failed to end login message: " + exception);
        }
        GlobeData.sendGlobeData(event);
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new FluteSongsReloadListener());
    }

    @SubscribeEvent
    public static void onPistonMoved(PistonEvent.Post event) {
        if (event.getPistonMoveType() == PistonEvent.PistonMoveType.RETRACT) {
            LevelAccessor level = event.getWorld();
            BlockPos blockPos = event.getPos();
        }
    }

    @SubscribeEvent
    public static void noteBlockEvent(NoteBlockEvent.Play event) {
        SongsManager.recordNote(event.getWorld(), event.getPos());
    }

    public static void onPlayerStartTracking(ChunkWatchEvent.Watch event) {
        ServerLevel serverLevel = event.getWorld();
        ChunkAccess chunk = serverLevel.m_7726_().m_7587_(event.getPos().f_45578_, event.getPos().f_45579_, ChunkStatus.f_62326_, false);
        if (chunk != null) {
            Set positions = chunk.m_5928_();
            ServerLevel level = event.getWorld();
            for (BlockPos pos : positions) {
                LazyOptional cap;
                BlockEntity te = level.m_7702_(pos);
                if (te == null || !(cap = te.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP)).isPresent()) continue;
                MinecraftServer server = serverLevel.m_142572_();
                IAntiqueTextProvider c = (IAntiqueTextProvider)cap.orElse(null);
                boolean a = c.hasAntiqueInk();
                server.m_6937_((Runnable)new TickTask(server.m_129921_(), () -> NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ((ChunkWatchEvent.Watch)event).getPlayer()), (Object)new ClientBoundSyncAntiqueInk(pos, a))));
            }
        }
    }
}

