/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;

public class VillagerTradesHandler {
    private static final float BUY = 0.05f;
    private static final float SELL = 0.2f;
    private static final VillagerTrades.ItemListing[] RED_MERCHANT_TRADES;
    private static VillagerTrades.ItemListing[] CHRISTMAS_SALES;

    public static VillagerTrades.ItemListing[] getRedMerchantTrades() {
        if (CommonUtil.FESTIVITY.isChristmas()) {
            if (CHRISTMAS_SALES == null) {
                CHRISTMAS_SALES = Arrays.stream(RED_MERCHANT_TRADES).map(WrappedListing::new).toList().toArray(new VillagerTrades.ItemListing[0]);
            }
            return CHRISTMAS_SALES;
        }
        return RED_MERCHANT_TRADES;
    }

    static BasicItemListing itemForEmeraldTrade(ItemLike item2, int quantity, int price, int maxTrades) {
        return VillagerTradesHandler.itemForEmeraldTrade(new ItemStack(item2, quantity), price, maxTrades);
    }

    static BasicItemListing itemForEmeraldTrade(ItemStack itemStack, int price, int maxTrades) {
        return new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, price), itemStack, maxTrades, 1, 0.05f);
    }

    static BasicItemListing itemForEmeraldTrade(ItemLike item2, int quantity, ItemLike additional, int addQuantity, int price, int maxTrades) {
        return new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, price), new ItemStack(additional, addQuantity), new ItemStack(item2, quantity), maxTrades, 1, 0.05f);
    }

    private static CompoundTag createRandomFireworkStar(Random random) {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("Type", (byte)FireworkRocketItem.Shape.values()[random.nextInt(FireworkRocketItem.Shape.values().length)].m_41236_());
        tag.m_128379_("Flicker", random.nextFloat() < 0.42f);
        tag.m_128379_("Trail", random.nextFloat() < 0.42f);
        ArrayList list = Lists.newArrayList();
        int colors = 0;
        do {
            list.add(DyeColor.values()[random.nextInt(DyeColor.values().length)].m_41070_());
        } while (random.nextFloat() < 0.42f && ++colors < 9);
        tag.m_128408_("Colors", (List)list);
        if (random.nextBoolean()) {
            ArrayList fadeList = Lists.newArrayList();
            colors = 0;
            do {
                fadeList.add(DyeColor.values()[random.nextInt(DyeColor.values().length)].m_41070_());
            } while (random.nextFloat() < 0.42f && ++colors < 9);
            tag.m_128408_("FadeColors", (List)fadeList);
        }
        return tag;
    }

    public static void registerWanderingTraderTrades(WandererTradesEvent event) {
        int i;
        if (((Boolean)RegistryConfigs.reg.GLOBE_ENABLED.get()).booleanValue()) {
            for (i = 0; i < ServerConfigs.cached.GLOBE_TRADES; ++i) {
                event.getRareTrades().add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.GLOBE_ITEM.get(), 1, 10, 3));
            }
        }
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
            for (i = 0; i < 2; ++i) {
                event.getGenericTrades().add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get(), 1, 6, 8));
            }
        }
    }

    public static void registerVillagerTrades(VillagerTradesEvent event) {
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue() && event.getType().equals(VillagerProfession.f_35590_)) {
            ((List)event.getTrades().get(3)).add(new BasicItemListing(new ItemStack((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get(), 15), new ItemStack((ItemLike)Items.f_42616_), 16, 2, 0.05f));
        }
        AdventurerMapsHandler.loadCustomTrades();
        AdventurerMapsHandler.addTrades(event);
    }

    static {
        ArrayList<Object> trades = new ArrayList<Object>();
        if (((Boolean)RegistryConfigs.reg.ROPE_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.ROPE_ITEM.get(), 4, 1, 10));
        }
        trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)Items.f_42403_, 2, 1, 8));
        if (((Boolean)RegistryConfigs.reg.COPPER_LANTERN_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.COPPER_LANTERN.get(), 1, 1, 12));
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.BOMB_ITEM.get(), 1, 3, 8));
        }
        trades.add(new StarForEmeraldTrade(2, 8));
        trades.add(new RocketForEmeraldTrade(3, 1, 3, 8));
        trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)Items.f_41996_, 1, 4, 8));
        if (((Boolean)RegistryConfigs.reg.ROPE_ARROW_ENABLED.get()).booleanValue()) {
            Item i = (Item)ModRegistry.ROPE_ARROW_ITEM.get();
            ItemStack stack = new ItemStack((ItemLike)i);
            stack.m_41721_(Math.max(0, stack.m_41776_() - 16));
            trades.add(VillagerTradesHandler.itemForEmeraldTrade(stack, 4, 6));
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((ItemLike)ModRegistry.BOMB_BLUE_ITEM.get(), 1, (ItemLike)ModRegistry.BOMB_ITEM.get(), 1, 40, 3));
        }
        RED_MERCHANT_TRADES = trades.toArray(new VillagerTrades.ItemListing[0]);
        CHRISTMAS_SALES = null;
    }

    record StarForEmeraldTrade(int price, int maxTrades) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_5670_(Entity entity2, Random random) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42689_);
            itemstack.m_41700_("Explosion", (Tag)VillagerTradesHandler.createRandomFireworkStar(random));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    record RocketForEmeraldTrade(int price, int paper, int rockets, int maxTrades) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_5670_(Entity entity2, Random random) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, this.rockets);
            CompoundTag tag = itemstack.m_41698_("Fireworks");
            ListTag listTag = new ListTag();
            int stars = 0;
            do {
                listTag.add((Object)VillagerTradesHandler.createRandomFireworkStar(random));
            } while (random.nextFloat() < 0.42f && ++stars < 7);
            tag.m_128344_("Flight", (byte)(random.nextInt(3) + 1));
            tag.m_128365_("Explosions", (Tag)listTag);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), new ItemStack((ItemLike)Items.f_42516_, this.paper), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    private record WrappedListing(VillagerTrades.ItemListing original) implements VillagerTrades.ItemListing
    {
        private static final PresentBlockTile DUMMY = new PresentBlockTile(BlockPos.f_121853_, ((Block)ModRegistry.PRESENTS.get(null).get()).m_49966_());

        public MerchantOffer m_5670_(Entity entity2, Random random) {
            MerchantOffer internal = this.original.m_5670_(entity2, random);
            if (internal == null) {
                return null;
            }
            DUMMY.m_6836_(0, internal.m_45368_());
            DUMMY.setSender(entity2.m_7755_().getString());
            DUMMY.setPublic();
            ItemStack stack = DUMMY.getPresentItem((ItemLike)ModRegistry.PRESENTS.get(DyeColor.values()[random.nextInt(DyeColor.values().length)]).get());
            return new MerchantOffer(internal.m_45352_(), internal.m_45364_(), stack, internal.m_45371_(), internal.m_45373_(), internal.m_45379_(), internal.m_45378_(), internal.m_45375_());
        }
    }
}

