/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.mehvahdjukaar.supplementaries.common.world.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BombEntity
extends ImprovedProjectileEntity
implements IEntityAdditionalSpawnData {
    private boolean blue;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public BombEntity(EntityType<? extends BombEntity> type, Level world) {
        super(type, world);
    }

    public BombEntity(Level worldIn, LivingEntity throwerIn, boolean blue) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModRegistry.BOMB.get()), throwerIn, worldIn);
        this.blue = blue;
        this.maxAge = 200;
    }

    public BombEntity(Level worldIn, double x, double y, double z, boolean blue) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModRegistry.BOMB.get()), x, y, z, worldIn);
        this.blue = blue;
        this.maxAge = 200;
    }

    public BombEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModRegistry.BOMB.get()), world);
        this.maxAge = 200;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128379_("Blue", this.blue);
        compound.m_128405_("Timer", this.changeTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.active = compound.m_128471_("Active");
        this.blue = compound.m_128471_("Blue");
        this.changeTimer = compound.m_128451_("Timer");
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.blue = buffer.readBoolean();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.blue);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_7881_() {
        return (Item)ModRegistry.BOMB_ITEM_ON.get();
    }

    public ItemStack m_7846_() {
        return this.blue ? new ItemStack(this.active ? (ItemLike)ModRegistry.BOMB_BLUE_ITEM_ON.get() : (ItemLike)ModRegistry.BOMB_BLUE_ITEM.get()) : new ItemStack(this.active ? (ItemLike)ModRegistry.BOMB_ITEM_ON.get() : (ItemLike)ModRegistry.BOMB_ITEM.get());
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            default: {
                super.m_7822_(id);
                break;
            }
            case 3: {
                this.spawnBreakParticles();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                if (CommonUtil.FESTIVITY.isBirthday()) {
                    this.spawnParticleInASphere((ParticleOptions)ModRegistry.CONFETTI_PARTICLE.get(), 55, 0.3f);
                } else {
                    this.f_19853_.m_7106_((ParticleOptions)ModRegistry.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), this.blue ? (double)ServerConfigs.cached.BOMB_BLUE_RADIUS : (double)ServerConfigs.cached.BOMB_RADIUS, 0.0, 0.0);
                }
                if (!this.blue) break;
                this.spawnParticleInASphere((ParticleOptions)ParticleTypes.f_123744_, 40, 0.55f);
                break;
            }
            case 68: {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                Random random = this.f_19853_.m_5822_();
                for (int i = 0; i < 10; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + 0.25 - (double)(random.nextFloat() * 0.5f), this.m_20186_() + (double)0.45f - (double)(random.nextFloat() * 0.5f), this.m_20189_() + 0.25 - (double)(random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
            }
        }
    }

    private void spawnParticleInASphere(ParticleOptions type, int amount, float speed) {
        double d = Math.PI * 2 / (double)amount;
        float d22 = 0.0f;
        while ((double)d22 < Math.PI * 2) {
            Vec3 v = new Vec3((double)speed, 0.0, 0.0);
            v = v.m_82524_(d22 + this.f_19796_.nextFloat() * 0.3f);
            v = v.m_82535_((float)((double)this.f_19796_.nextFloat() * Math.PI));
            this.f_19853_.m_7106_(type, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), v.f_82479_, v.f_82480_, v.f_82481_);
            d22 = (float)((double)d22 + d);
        }
    }

    private double r() {
        return this.f_19796_.nextGaussian() * 0.05;
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    @Override
    public void m_8119_() {
        if (this.changeTimer > 0) {
            --this.changeTimer;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.active && this.m_20069_() && !this.blue) {
            this.turnOff();
        }
        super.m_8119_();
    }

    @Override
    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (this.active && !this.f_19803_) {
            double x = currentPos.f_82479_;
            double y = currentPos.f_82480_;
            double z = currentPos.f_82481_;
            double dx = newPos.f_82479_ - x;
            double dy = newPos.f_82480_ - y;
            double dz = newPos.f_82481_ - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = (double)i / (double)s;
                this.f_19853_.m_7106_((ParticleOptions)ModRegistry.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0.0, 0.02, 0.0);
            }
        }
    }

    public static boolean canBreakBlock(BlockState state, boolean blue) {
        return switch (blue ? ServerConfigs.cached.BOMB_BLUE_BREAKS : ServerConfigs.cached.BOMB_BREAKS) {
            default -> false;
            case breakingMode.ALL -> true;
            case breakingMode.WEAK -> state.m_60722_((Fluid)Fluids.f_76193_) || state.m_60620_(ModTags.BOMB_BREAKABLE) || state.m_60734_() instanceof TntBlock;
        };
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        hit.m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 1.0f);
        if (hit.m_82443_() instanceof LargeFireball) {
            this.superCharged = true;
            hit.m_82443_().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void turnOff() {
        if (!this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)67);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
        }
        this.active = false;
    }

    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_ && !this.active && entityIn.m_150109_().m_36054_(this.getItemStack())) {
            entityIn.m_7938_((Entity)this, 1);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private ItemStack getItemStack() {
        return new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get());
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 vector3d = hit.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_((double)this.m_7139_());
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            if (this.blue && this.changeTimer == -1) {
                this.changeTimer = 10;
                this.f_19853_.m_7605_((Entity)this, (byte)68);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.5f, 1.3f);
            }
            if (!(this.m_146910_() || this.blue && !this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void m_37283_() {
    }

    @Override
    public void reachedEndOfLife() {
        if (this.active) {
            this.createExplosion();
            this.f_19853_.m_7605_((Entity)this, (byte)10);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.5f, 1.5f);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void createExplosion() {
        boolean breaks;
        boolean bl = breaks = this.m_37282_() instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
        if (this.superCharged) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, breaks, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        }
        BombExplosion explosion = new BombExplosion(this.f_19853_, (Entity)this, null, new ExplosionDamageCalculator(){

            public boolean m_6714_(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
                return BombEntity.canBreakBlock(state, BombEntity.this.blue);
            }
        }, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), this.blue ? ServerConfigs.cached.BOMB_BLUE_RADIUS : ServerConfigs.cached.BOMB_RADIUS, this.blue, breaks ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
        explosion.m_46061_();
        explosion.doFinalizeExplosion();
    }

    public static enum breakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

