/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities.mobholder;

import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.BaseCatchableMobCap;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.MobContainer;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultCatchableMobCap<T extends Entity>
extends BaseCatchableMobCap<T> {
    private final CapturedMobsHelper.CapturedMobConfigProperties properties;
    protected float jumpY = 0.0f;
    protected float prevJumpY = 0.0f;
    protected float yVel = 0.0f;

    public DefaultCatchableMobCap(T entity2) {
        super(entity2);
        this.properties = CapturedMobsHelper.getType(entity2);
    }

    @Override
    public float getHitBoxWidthIncrement() {
        return this.properties.getWidth();
    }

    @Override
    public float getHitBoxHeightIncrement() {
        return this.properties.getHeight();
    }

    @Override
    public int getLightLevel() {
        return this.properties.getLightLevel();
    }

    @Override
    public boolean canBeCaughtWithItem(Item item2) {
        if (this.mob instanceof Slime && ((Slime)this.mob).m_33632_() > 1) {
            return false;
        }
        if (this.mob instanceof Bee) {
            return true;
        }
        if (item2 instanceof AbstractMobContainerItem) {
            return ((AbstractMobContainerItem)item2).canItemCatch(this.mob);
        }
        return false;
    }

    @Override
    public boolean canBeCaughtWithJar() {
        return false;
    }

    @Override
    public boolean canBeCaughtWithTintedJar() {
        return false;
    }

    @Override
    public boolean canBeCaughtWithCage() {
        return false;
    }

    @Override
    public void onContainerWaterlogged(boolean waterlogged) {
        if (this.mob instanceof WaterAnimal && this.mob.m_20069_() != waterlogged) {
            this.mob.f_19798_ = waterlogged;
            Pair<Float, Float> dim = MobContainer.calculateMobDimensionsForContainer(this, this.containerWidth, this.containerHeight, waterlogged);
            double py = (double)((Float)dim.getRight()).floatValue() + 1.0E-4;
            this.mob.m_6034_(this.mob.m_20185_(), py, this.mob.m_20189_());
            this.mob.f_19791_ = py;
        }
    }

    @Override
    public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
        if (world.f_46443_) {
            if (this.properties.isFloating()) {
                this.jumpY = 0.04f * Mth.m_14031_((float)((float)this.mob.f_19797_ / 10.0f)) - 0.03f;
            }
            this.mob.f_19791_ = this.mob.m_20186_();
            float dy = this.jumpY - this.prevJumpY;
            if (dy != 0.0f) {
                this.mob.m_6034_(this.mob.m_20185_(), this.mob.m_20186_() + (double)dy, this.mob.m_20189_());
            }
            this.prevJumpY = this.jumpY;
        }
    }

    @Override
    public boolean isFlyingMob(boolean waterlogged) {
        CapturedMobsHelper.AnimationCategory cat = this.getAnimationCategory();
        return !cat.isLand() && (cat.isFlying() || this.mob.m_20068_() || this.mob instanceof FlyingAnimal || this.mob.m_6090_() || this.mob instanceof WaterAnimal && waterlogged);
    }

    public CapturedMobsHelper.AnimationCategory getAnimationCategory() {
        return this.properties.getCategory();
    }

    public static <E extends Entity> ICatchableMob getDefaultCap(E e) {
        if (e.f_19853_.f_46443_ && e instanceof LivingEntity && ((List)ClientConfigs.block.TICKLE_MOBS.get()).contains(e.m_6095_().getRegistryName().toString())) {
            return new ClientTickableAnim((LivingEntity)e);
        }
        if (e instanceof Squid) {
            return new DoubleSideTickableAnim((LivingEntity)e);
        }
        if (e instanceof Slime) {
            return new SlimeAnim((Slime)e);
        }
        if (e instanceof Parrot) {
            return new ParrotAnim((Parrot)e);
        }
        if (e instanceof Rabbit) {
            return new RabbitAnim((Rabbit)e);
        }
        if (e instanceof Chicken) {
            return new ChickenAnim((Chicken)e);
        }
        if (e instanceof Endermite) {
            return new EndermiteAnim((Endermite)e);
        }
        return new DefaultCatchableMobCap<E>(e);
    }

    public static class ClientTickableAnim
    extends DefaultCatchableMobCap<LivingEntity> {
        public ClientTickableAnim(LivingEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            if (world.f_46443_) {
                ((LivingEntity)this.mob).m_8107_();
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class DoubleSideTickableAnim
    extends DefaultCatchableMobCap<LivingEntity> {
        public DoubleSideTickableAnim(LivingEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            ((LivingEntity)this.mob).m_8107_();
            if (world.f_46443_) {
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class SlimeAnim
    extends DefaultCatchableMobCap<Slime> {
        public SlimeAnim(Slime entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            if (world.f_46443_) {
                ((Slime)this.mob).f_33584_ += (((Slime)this.mob).f_33581_ - ((Slime)this.mob).f_33584_) * 0.5f;
                ((Slime)this.mob).f_33585_ = ((Slime)this.mob).f_33584_;
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.01f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                        ((Slime)this.mob).f_33581_ = -0.5f;
                    }
                    if ((double)world.m_5822_().nextFloat() > 0.985) {
                        this.yVel = 0.08f;
                        ((Slime)this.mob).f_33581_ = 1.0f;
                    }
                }
                ((Slime)this.mob).f_33581_ *= 0.6f;
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class ParrotAnim
    extends DefaultCatchableMobCap<Parrot> {
        public ParrotAnim(Parrot entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            if (world.f_46443_) {
                ((Parrot)this.mob).m_8107_();
                boolean p = ((Parrot)this.mob).m_29439_();
                ((Parrot)this.mob).m_6853_(p);
                this.jumpY = p ? 0.0f : 0.0625f;
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class RabbitAnim
    extends DefaultCatchableMobCap<Rabbit> {
        public RabbitAnim(Rabbit entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            if (world.f_46443_) {
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.017f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                    }
                    if ((double)world.f_46441_.nextFloat() > 0.985) {
                        this.yVel = 0.093f;
                        ((Rabbit)this.mob).m_29716_();
                    }
                }
                ((Rabbit)this.mob).m_8107_();
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class ChickenAnim
    extends DefaultCatchableMobCap<Chicken> {
        public ChickenAnim(Chicken entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            Random rand = world.m_5822_();
            if (!world.f_46443_) {
                if (--((Chicken)this.mob).f_28231_ <= 0) {
                    ((Chicken)this.mob).m_19998_((ItemLike)Items.f_42521_);
                    ((Chicken)this.mob).f_28231_ = rand.nextInt(6000) + 6000;
                }
            } else {
                ((Chicken)this.mob).m_8107_();
                double d = world.f_46441_.nextFloat();
                double d2 = ((Chicken)this.mob).m_20096_() ? 0.99 : 0.88;
                if (d > d2) {
                    ((Chicken)this.mob).m_6853_(!((Chicken)this.mob).m_20096_());
                }
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class EndermiteAnim
    extends DefaultCatchableMobCap<Endermite> {
        public EndermiteAnim(Endermite entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(Level world, BlockPos pos, float mobScale, CompoundTag tag) {
            if (world.f_46443_) {
                if (world.f_46441_.nextFloat() > 0.7f) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.2f), (double)((float)pos.m_123343_() + 0.5f), (world.f_46441_.nextDouble() - 0.5) * 2.0, -world.f_46441_.nextDouble(), (world.f_46441_.nextDouble() - 0.5) * 2.0);
                }
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }
}

