/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SwayingBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SwayingBlockTile
extends BlockEntity {
    public float angle = 0.0f;
    public float prevAngle = 0.0f;
    public int counter = 800 + new Random().nextInt(80);
    public boolean inv = false;
    protected static float maxSwingAngle = 45.0f;
    protected static float minSwingAngle = 2.5f;
    protected static float maxPeriod = 25.0f;
    protected static float angleDamping = 150.0f;
    protected static float periodDamping = 100.0f;
    public boolean fancyRenderer = false;
    protected boolean oldRendererState = false;

    public SwayingBlockTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return null;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)SwayingBlock.FACING);
    }

    public void setFancyRenderer(boolean fancy) {
        if (ClientConfigs.cached.FAST_LANTERNS) {
            fancy = false;
        }
        if (fancy != this.fancyRenderer) {
            this.oldRendererState = this.fancyRenderer;
            this.fancyRenderer = fancy;
            if (this.f_58857_ == Minecraft.m_91087_().f_91073_) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 8);
            }
        }
    }

    public boolean shouldRenderFancy() {
        if (this.oldRendererState != this.fancyRenderer) {
            this.oldRendererState = this.fancyRenderer;
            return this.oldRendererState;
        }
        return this.fancyRenderer;
    }

    public boolean hasAnimation() {
        return true;
    }

    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, SwayingBlockTile tile) {
        if (tile.hasAnimation()) {
            ++tile.counter;
            tile.prevAngle = tile.angle;
            float a = minSwingAngle;
            float k = 0.01f;
            if (tile.counter < 800) {
                a = (float)Math.max((double)maxSwingAngle * Math.pow(Math.E, -((float)tile.counter / angleDamping)), (double)minSwingAngle);
                k = (float)Math.max(Math.PI * 2 * (double)((float)Math.pow(Math.E, -((float)tile.counter / periodDamping))), (double)0.01f);
            }
            tile.angle = (tile.angle = a * Mth.m_14089_((float)((float)tile.counter / maxPeriod - k))) * (tile.inv ? -1.0f : 1.0f);
        }
    }
}

