/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.DoubleSkullBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EnhancedSkullBlockTile
extends BlockEntity {
    @Nullable
    private GameProfile owner;
    private SkullBlock.Types type = SkullBlock.Types.SKELETON;

    public EnhancedSkullBlockTile(BlockEntityType type, BlockPos pWorldPosition, BlockState pBlockState) {
        super(type, pWorldPosition, pBlockState);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Type", this.type.ordinal());
        if (this.owner != null) {
            CompoundTag compoundtag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compoundtag, (GameProfile)this.owner);
            tag.m_128365_("SkullOwner", (Tag)compoundtag);
        }
    }

    public void m_142466_(CompoundTag tag) {
        String s;
        super.m_142466_(tag);
        this.type = SkullBlock.Types.values()[tag.m_128451_("Type")];
        if (tag.m_128425_("SkullOwner", 10)) {
            this.setOwner(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("SkullOwner")));
        } else if (tag.m_128425_("ExtraType", 8) && !StringUtil.m_14408_((String)(s = tag.m_128461_("ExtraType")))) {
            this.setOwner(new GameProfile(null, s));
        }
    }

    @Nullable
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile pOwner) {
        EnhancedSkullBlockTile enhancedSkullBlockTile = this;
        synchronized (enhancedSkullBlockTile) {
            this.owner = pOwner;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        SkullBlockEntity.m_155738_((GameProfile)this.owner, gameProfile -> {
            this.owner = gameProfile;
            this.m_6596_();
        });
    }

    public void setSkullType(SkullBlock.Types type) {
        this.type = type;
    }

    public SkullBlock.Types getSkullType() {
        return this.type;
    }

    public ItemStack getSkullItem() {
        return DoubleSkullBlockTile.getSkullItem((SkullBlock.Type)this.type, this.owner);
    }

    public static ItemStack getSkullItem(SkullBlock.Type type, GameProfile profile) {
        if (type instanceof SkullBlock.Types) {
            SkullBlock.Types types = (SkullBlock.Types)type;
            Item i = switch (types) {
                default -> throw new IncompatibleClassChangeError();
                case SkullBlock.Types.SKELETON -> Items.f_42678_;
                case SkullBlock.Types.WITHER_SKELETON -> Items.f_42679_;
                case SkullBlock.Types.ZOMBIE -> Items.f_42681_;
                case SkullBlock.Types.PLAYER -> Items.f_42680_;
                case SkullBlock.Types.DRAGON -> Items.f_42683_;
                case SkullBlock.Types.CREEPER -> Items.f_42682_;
            };
            ItemStack stack = new ItemStack((ItemLike)i);
            if (types == SkullBlock.Types.PLAYER && profile != null) {
                CompoundTag tag = new CompoundTag();
                NbtUtils.m_129230_((CompoundTag)tag, (GameProfile)profile);
                stack.m_41700_("SkullOwner", (Tag)tag);
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void initialize(SkullBlockEntity oldTile, SkullBlock skullBlock, ItemStack stack, Player player) {
        this.setOwner(oldTile.m_59779_());
        this.setSkullType((SkullBlock.Types)skullBlock.m_48754_());
    }
}

